<?php
/**
 * Checks if there is a non-virtual robots.txt file and if yes, show it.
 *
 * @package Site Health Tools
 */

namespace SiteHealthTools;

// Make sure the file is not directly accessible.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'We\'re sorry, but you can not directly access this file.' );
}

/**
 * Class Mail Check
 */
class Robotstxt extends Site_Health_Tool {

	public function __construct() {
		parent::__construct();
	}

	public function set_tool_details() {
		$this->label       = \__( 'robots.txt Viewer', 'site-health-tools' );
		$this->description = \__( 'The <code>robots.txt</code> file tells search engines which directories are allowed to be crawled and which not. WordPress generates a virtual file if there is no physical file. If there is a non-virtual file, the content will be displayed here.', 'site-health-tools' );
	}

	public function tab_content() : void {
		global $wp_rewrite;

		if ( file_exists( ABSPATH . 'robots.txt' ) ) {
			printf(
				'<pre>%s</pre>',
				\esc_html( (string) file_get_contents( ABSPATH . 'robots.txt' ) )
			);
		} else {
			printf(
				'<p>%s</p>',
				sprintf(
					// translators: %s: The `robots.txt` file identifier within code tags.
					\esc_html__( 'Your site is using the virtual %s file which is generated by WordPress.', 'site-health-tools' ),
					'<code>robots.txt</code>'
				)
			);
		}
		?>
		<?php
	}

}

new Robotstxt();
