<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$options = get_option("gptranslate_options");

// UPGRADE period
echo '<div class="notice notice-warning is-dismissible"><p>⚠️ GPTranslate runs in FREE Mode with usage limits. To unlock unlimited translations and advanced features, upgrade to the <a href="https://storejextensions.org/extensions/gptranslate.html" target="_blank"><strong>PRO version</strong></a>. Current FREE Plan: translate up to <strong>500 words</strong>, read aloud up to <strong>100 words</strong> per page and crawl up to <strong>10 pages</strong>. Don’t lose AI power – <a href="https://storejextensions.org/extensions/gptranslate.html" target="_blank">Upgrade Now</a>.</p></div>';
?>
<h1><img class="gptranslate-plugin-icon" src="data:image/png;base64,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"/> <?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SETTINGS_HEADER')); // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?></h1>

<div class="exportimportbtns">
	<form method="post" action="<?php echo esc_attr(admin_url('admin-post.php'));?>" enctype="multipart/form-data">
		<?php wp_nonce_field('gptranslate_import_settings', 'gptranslate_import_settings_nonce'); ?>
		<input type="submit" class="button button-primary toggle-import hidden" value="<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_IMPORT_CONFIRM'));?>">
		<input type="file" name="gptranslate_settings_file" class="toggle-import hidden" accept=".json" required>
		<input type="hidden" name="action" value="gptranslate_import_settings">
	</form>
	<input type="button" class="button button-primary button-import" value="<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_IMPORT_SETTINGS'));?>">
	<form method="post" action="admin-post.php">
		<?php wp_nonce_field('gptranslate_export_settings', 'gptranslate_export_settings_nonce'); ?>
		<input type="hidden" name="action" value="gptranslate_export_settings">
		<input type="submit" class="button button-primary" value="<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_EXPORT_CONFIRM'));?>">
	</form>
</div>

<h2 class='nav-tab-wrapper'>
   <a href='#translator' class='nav-tab nav-tab-active' data-click='translator'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATOR_FIELDSET_LABEL')); ?></a>
   <a href='#reader' class='nav-tab' data-click='reader'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_READER_FIELDSET_LABEL')); ?></a>
   <a href='#appearance' class='nav-tab' data-click='appearance'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_APPEARANCE_FIELDSET_LABEL')); ?></a>
</h2>
	<form method='post' id="config-gptranslate" action='options.php'>
	<div id='tab-translator' class='tab-content' style='display: block;'>
	  <p><input type='submit' class='button-primary' value='<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'></p>
      <?php settings_fields('gptranslate_settings'); do_settings_sections('gptranslate'); ?>
      <table class='form-table'>
      	<tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_TRANSLATOR_SETTINGS')); ?></label></th>
            <td>
            </td>
		</tr>
		<tr>
            <th scope='row'><label for='google_translate_engine'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_TRANSLATION_ENGINE')); ?></label></th>
            <td>
               <select name="gptranslate_options[google_translate_engine]" id='google_translate_engine'>
                  <option value='1'<?php selected($options["google_translate_engine"] ?? "1", "1"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_TRANSLATION_ENGINE_GTRANSLATE')); ?></option>
                  <option value='0'<?php selected($options["google_translate_engine"] ?? "1", "0"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_TRANSLATION_ENGINE_CHATGPT')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_TRANSLATION_ENGINE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='chatgpt_apikey'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_APIKEY')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[chatgpt_apikey]" id='chatgpt_apikey' value='<?php echo esc_attr($options["chatgpt_apikey"] ?? ""); ?>' class='regular-text chatgpt_ctrl large-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_APIKEY_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='chatgpt_model'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_MODEL')); ?></label></th>
            <td>
				<select name="gptranslate_options[chatgpt_model]" id='chatgpt_model' class="chatgpt_ctrl">
				    <option value='gpt-3.5-turbo'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-3.5-turbo"); ?>>GPT-3.5-Turbo</option>
				    <option value='gpt-4'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4"); ?>>GPT-4</option>
				    <option value='gpt-4o'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4o"); ?>>GPT-4o</option>
				    <option value='gpt-4o-mini'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4o-mini"); ?>>GPT-4o Mini</option>
				    <option value='gpt-4.1'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4.1"); ?>>GPT-4.1</option>
				    <option value='gpt-4.1-mini'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4.1-mini"); ?>>GPT-4.1 Mini</option>
				    <option value='gpt-4.1-nano'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-4.1-nano"); ?>>GPT-4.1 Nano</option>
				    <option value='gpt-5'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-5"); ?>>GPT-5</option>
				    <option value='gpt-5-mini'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-5-mini"); ?>>GPT-5 Mini</option>
				    <option value='gpt-5-nano'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-5-nano"); ?>>GPT-5 Nano</option>
				    <option value='gpt-5.1'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-5.1"); ?>>GPT-5.1</option>
				    <option value='gpt-5.2'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gpt-5.2"); ?>>GPT-5.2</option>
				    <option value='deepseek-chat'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "deepseek-chat"); ?>>DeepSeek Chat</option>
				    <option value='gemini-1.5-flash'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-1.5-flash"); ?>>Gemini 1.5 Flash</option>
				    <option value='gemini-1.5-pro'<?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-1.5-pro"); ?>>Gemini 1.5 Pro</option>
				    <option value='gemini-2.0-flash' <?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-2.0-flash"); ?>>Gemini 2.0 Flash</option>
				    <option value='gemini-2.0-flash-lite' <?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-2.0-flash-lite"); ?>>Gemini 2.0 Flash Lite</option>
				    <option value='gemini-2.5-flash' <?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-2.5-flash"); ?>>Gemini 2.5 Flash</option>
				    <option value='gemini-2.5-pro' <?php selected($options["chatgpt_model"] ?? "gpt-3.5-turbo", "gemini-2.5-pro"); ?>>Gemini 2.5 Pro</option>
				</select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_MODEL_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='chatgpt_request_message'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_MESSAGE')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[chatgpt_request_message]" id='chatgpt_request_message' class='large-text chatgpt_ctrl' rows='5'><?php echo esc_textarea($options["chatgpt_request_message"] ?? "Compile this JSON object key-value pairs adding the translation into '{{target}}' language to the empty value from the original '{{source}}' language of the key and return me only a parsable JSON object without any surrounding characters, preserve and return in the JSON object the key in the original '{{source}}' language within double quotes: '{{translations}}'. Pay attention to not skip any key and translate all keys. Return only a parsable JSON object with no surrounding text, explanations, or markdown formatting. Ensure the response is valid JSON and can be parsed directly."); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_MESSAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='chatgpt_request_conversation_mode'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_CONVERSATION_MODE')); ?></label></th>
            <td>
               	<select name="gptranslate_options[chatgpt_request_conversation_mode]" id='chatgpt_request_conversation_mode' class="chatgpt_ctrl">
					<option value='user'<?php selected($options["chatgpt_request_conversation_mode"] ?? "user", "user"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_CONVERSATION_MODE_USER')); ?></option>
					<option value='system'<?php selected($options["chatgpt_request_conversation_mode"] ?? "user", "system"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_CONVERSATION_MODE_SYSTEM')); ?></option>
				</select>
				<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_REQUEST_CONVERSATION_MODE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='max_translations_per_request'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAX_NUMBER_TRANSLATIONS_PER_REQUEST')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[max_translations_per_request]" id='max_translations_per_request' value='<?php echo esc_attr($options["max_translations_per_request"] ?? "100"); ?>' class='regular-text chatgpt_ctrl' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAX_NUMBER_TRANSLATIONS_PER_REQUEST_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='max_characters_per_request'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAX_NUMBER_CHARACTERS_PER_REQUEST')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[max_characters_per_request]" id='max_characters_per_request' value='<?php echo esc_attr($options["max_characters_per_request"] ?? "2048"); ?>' class='regular-text chatgpt_ctrl' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAX_NUMBER_CHARACTERS_PER_REQUEST_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_ORIGINAL_LANGUAGE')); ?></label></th>
            <td>
               <select name="gptranslate_options[language]" id='language'>
				  <option value='af'<?php selected($options["language"] ?? "en" ? : "en", "af"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AF')); ?></option>
				  <option value='sq'<?php selected($options["language"] ?? "en" ? : "en", "sq"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SQ')); ?></option>
				  <option value='am'<?php selected($options["language"] ?? "en" ? : "en", "am"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AM')); ?></option>
				  <option value='ar'<?php selected($options["language"] ?? "en" ? : "en", "ar"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AR')); ?></option>
				  <option value='hy'<?php selected($options["language"] ?? "en" ? : "en", "hy"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HY')); ?></option>
				  <option value='az'<?php selected($options["language"] ?? "en" ? : "en", "az"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AZ')); ?></option>
				  <option value='eu'<?php selected($options["language"] ?? "en" ? : "en", "eu"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EU')); ?></option>
				  <option value='be'<?php selected($options["language"] ?? "en" ? : "en", "be"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BE')); ?></option>
				  <option value='bn'<?php selected($options["language"] ?? "en" ? : "en", "bn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BN')); ?></option>
				  <option value='bs'<?php selected($options["language"] ?? "en" ? : "en", "bs"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BS')); ?></option>
				  <option value='bg'<?php selected($options["language"] ?? "en" ? : "en", "bg"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BG')); ?></option>
				  <option value='ca'<?php selected($options["language"] ?? "en" ? : "en", "ca"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CA')); ?></option>
				  <option value='ceb'<?php selected($options["language"] ?? "en" ? : "en", "ceb"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CEB')); ?></option>
				  <option value='ny'<?php selected($options["language"] ?? "en" ? : "en", "ny"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NY')); ?></option>
				  <option value='zh'<?php selected($options["language"] ?? "en" ? : "en", "zh"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZH')); ?></option>
				  <option value='zt'<?php selected($options["language"] ?? "en" ? : "en", "zt"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZT')); ?></option>
				  <option value='co'<?php selected($options["language"] ?? "en" ? : "en", "co"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CO')); ?></option>
				  <option value='hr'<?php selected($options["language"] ?? "en" ? : "en", "hr"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HR')); ?></option>
				  <option value='cs'<?php selected($options["language"] ?? "en" ? : "en", "cs"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CS')); ?></option>
				  <option value='da'<?php selected($options["language"] ?? "en" ? : "en", "da"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DA')); ?></option>
				  <option value='nl'<?php selected($options["language"] ?? "en" ? : "en", "nl"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NL')); ?></option>
				  <option value='en'<?php selected($options["language"] ?? "en" ? : "en", "en"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EN')); ?></option>
				  <option value='eo'<?php selected($options["language"] ?? "en" ? : "en", "eo"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EO')); ?></option>
				  <option value='et'<?php selected($options["language"] ?? "en" ? : "en", "et"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ET')); ?></option>
				  <option value='tl'<?php selected($options["language"] ?? "en" ? : "en", "tl"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TL')); ?></option>
				  <option value='fi'<?php selected($options["language"] ?? "en" ? : "en", "fi"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FI')); ?></option>
				  <option value='fr'<?php selected($options["language"] ?? "en" ? : "en", "fr"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FR')); ?></option>
				  <option value='fy'<?php selected($options["language"] ?? "en" ? : "en", "fy"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FY')); ?></option>
				  <option value='gl'<?php selected($options["language"] ?? "en" ? : "en", "gl"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GL')); ?></option>
				  <option value='ka'<?php selected($options["language"] ?? "en" ? : "en", "ka"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KA')); ?></option>
				  <option value='de'<?php selected($options["language"] ?? "en" ? : "en", "de"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DE')); ?></option>
				  <option value='el'<?php selected($options["language"] ?? "en" ? : "en", "el"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EL')); ?></option>
				  <option value='gu'<?php selected($options["language"] ?? "en" ? : "en", "gu"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GU')); ?></option>
				  <option value='ht'<?php selected($options["language"] ?? "en" ? : "en", "ht"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HT')); ?></option>
				  <option value='ha'<?php selected($options["language"] ?? "en" ? : "en", "ha"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HA')); ?></option>
				  <option value='haw'<?php selected($options["language"] ?? "en" ? : "en", "haw"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HAW')); ?></option>
				  <option value='iw'<?php selected($options["language"] ?? "en" ? : "en", "iw"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IW')); ?></option>
				  <option value='hi'<?php selected($options["language"] ?? "en" ? : "en", "hi"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HI')); ?></option>
				  <option value='hmn'<?php selected($options["language"] ?? "en" ? : "en", "hmn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HMN')); ?></option>
				  <option value='hu'<?php selected($options["language"] ?? "en" ? : "en", "hu"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HU')); ?></option>
				  <option value='is'<?php selected($options["language"] ?? "en" ? : "en", "is"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IS')); ?></option>
				  <option value='ig'<?php selected($options["language"] ?? "en" ? : "en", "ig"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IG')); ?></option>
				  <option value='id'<?php selected($options["language"] ?? "en" ? : "en", "id"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ID')); ?></option>
				  <option value='ga'<?php selected($options["language"] ?? "en" ? : "en", "ga"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GA')); ?></option>
				  <option value='it'<?php selected($options["language"] ?? "en" ? : "en", "it"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IT')); ?></option>
				  <option value='ja'<?php selected($options["language"] ?? "en" ? : "en", "ja"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JA')); ?></option>
				  <option value='jw'<?php selected($options["language"] ?? "en" ? : "en", "jw"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JW')); ?></option>
				  <option value='kn'<?php selected($options["language"] ?? "en" ? : "en", "kn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KN')); ?></option>
				  <option value='kk'<?php selected($options["language"] ?? "en" ? : "en", "kk"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KK')); ?></option>
				  <option value='km'<?php selected($options["language"] ?? "en" ? : "en", "km"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KM')); ?></option>
				  <option value='ko'<?php selected($options["language"] ?? "en" ? : "en", "ko"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KO')); ?></option>
				  <option value='ku'<?php selected($options["language"] ?? "en" ? : "en", "ku"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KU')); ?></option>
				  <option value='ky'<?php selected($options["language"] ?? "en" ? : "en", "ky"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KY')); ?></option>
				  <option value='lo'<?php selected($options["language"] ?? "en" ? : "en", "lo"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LO')); ?></option>
				  <option value='la'<?php selected($options["language"] ?? "en" ? : "en", "la"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LA')); ?></option>
				  <option value='lv'<?php selected($options["language"] ?? "en" ? : "en", "lv"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LV')); ?></option>
				  <option value='lt'<?php selected($options["language"] ?? "en" ? : "en", "lt"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LT')); ?></option>
				  <option value='lb'<?php selected($options["language"] ?? "en" ? : "en", "lb"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LB')); ?></option>
				  <option value='mk'<?php selected($options["language"] ?? "en" ? : "en", "mk"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MK')); ?></option>
				  <option value='mg'<?php selected($options["language"] ?? "en" ? : "en", "mg"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MG')); ?></option>
				  <option value='ms'<?php selected($options["language"] ?? "en" ? : "en", "ms"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MS')); ?></option>
				  <option value='ml'<?php selected($options["language"] ?? "en" ? : "en", "ml"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ML')); ?></option>
				  <option value='mt'<?php selected($options["language"] ?? "en" ? : "en", "mt"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MT')); ?></option>
				  <option value='mi'<?php selected($options["language"] ?? "en" ? : "en", "mi"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MI')); ?></option>
				  <option value='mr'<?php selected($options["language"] ?? "en" ? : "en", "mr"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MR')); ?></option>
				  <option value='mn'<?php selected($options["language"] ?? "en" ? : "en", "mn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MN')); ?></option>
				  <option value='my'<?php selected($options["language"] ?? "en" ? : "en", "my"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MY')); ?></option>
				  <option value='ne'<?php selected($options["language"] ?? "en" ? : "en", "ne"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NE')); ?></option>
				  <option value='no'<?php selected($options["language"] ?? "en" ? : "en", "no"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NO')); ?></option>
				  <option value='ps'<?php selected($options["language"] ?? "en" ? : "en", "ps"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PS')); ?></option>
				  <option value='fa'<?php selected($options["language"] ?? "en" ? : "en", "fa"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FA')); ?></option>
				  <option value='pl'<?php selected($options["language"] ?? "en" ? : "en", "pl"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PL')); ?></option>
				  <option value='pt'<?php selected($options["language"] ?? "en" ? : "en", "pt"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PT')); ?></option>
				  <option value='pa'<?php selected($options["language"] ?? "en" ? : "en", "pa"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PA')); ?></option>
				  <option value='ro'<?php selected($options["language"] ?? "en" ? : "en", "ro"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RO')); ?></option>
				  <option value='ru'<?php selected($options["language"] ?? "en" ? : "en", "ru"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RU')); ?></option>
				  <option value='sm'<?php selected($options["language"] ?? "en" ? : "en", "sm"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SM')); ?></option>
				  <option value='gd'<?php selected($options["language"] ?? "en" ? : "en", "gd"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GD')); ?></option>
				  <option value='sr'<?php selected($options["language"] ?? "en" ? : "en", "sr"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SR')); ?></option>
				  <option value='st'<?php selected($options["language"] ?? "en" ? : "en", "st"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ST')); ?></option>
				  <option value='sn'<?php selected($options["language"] ?? "en" ? : "en", "sn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SN')); ?></option>
				  <option value='sd'<?php selected($options["language"] ?? "en" ? : "en", "sd"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SD')); ?></option>
				  <option value='si'<?php selected($options["language"] ?? "en" ? : "en", "si"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SI')); ?></option>
				  <option value='sk'<?php selected($options["language"] ?? "en" ? : "en", "sk"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SK')); ?></option>
				  <option value='sl'<?php selected($options["language"] ?? "en" ? : "en", "sl"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SL')); ?></option>
				  <option value='so'<?php selected($options["language"] ?? "en" ? : "en", "so"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SO')); ?></option>
				  <option value='es'<?php selected($options["language"] ?? "en" ? : "en", "es"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ES')); ?></option>
				  <option value='su'<?php selected($options["language"] ?? "en" ? : "en", "su"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SU')); ?></option>
				  <option value='sw'<?php selected($options["language"] ?? "en" ? : "en", "sw"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SW')); ?></option>
				  <option value='sv'<?php selected($options["language"] ?? "en" ? : "en", "sv"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SV')); ?></option>
				  <option value='tg'<?php selected($options["language"] ?? "en" ? : "en", "tg"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TG')); ?></option>
				  <option value='ta'<?php selected($options["language"] ?? "en" ? : "en", "ta"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TA')); ?></option>
				  <option value='te'<?php selected($options["language"] ?? "en" ? : "en", "te"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TE')); ?></option>
				  <option value='th'<?php selected($options["language"] ?? "en" ? : "en", "th"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TH')); ?></option>
				  <option value='tr'<?php selected($options["language"] ?? "en" ? : "en", "tr"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TR')); ?></option>
				  <option value='uk'<?php selected($options["language"] ?? "en" ? : "en", "uk"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UK')); ?></option>
				  <option value='ur'<?php selected($options["language"] ?? "en" ? : "en", "ur"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UR')); ?></option>
				  <option value='uz'<?php selected($options["language"] ?? "en" ? : "en", "uz"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UZ')); ?></option>
				  <option value='vi'<?php selected($options["language"] ?? "en" ? : "en", "vi"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_VI')); ?></option>
				  <option value='cy'<?php selected($options["language"] ?? "en" ? : "en", "cy"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CY')); ?></option>
				  <option value='xh'<?php selected($options["language"] ?? "en" ? : "en", "xh"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_XH')); ?></option>
				  <option value='yi'<?php selected($options["language"] ?? "en" ? : "en", "yi"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YI')); ?></option>
				  <option value='yo'<?php selected($options["language"] ?? "en" ? : "en", "yo"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YO')); ?></option>
				  <option value='zu'<?php selected($options["language"] ?? "en" ? : "en", "zu"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZU')); ?></option>
				</select>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_ORIGINAL_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='languages'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLED_LANGUAGES')); ?></label></th>
            <td>
            	<?php 
            	// Convert the string to an array
            	$languages_array = $options['languages'] ?? [];
            	?>
               <select name="gptranslate_options[languages][]" multiple size="20" id='languages' class="select2-dropdown">
                  <option value='af'<?php echo esc_attr(check_selected("af", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AF')); ?></option>
                  <option value='sq'<?php echo esc_attr(check_selected("sq", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SQ')); ?></option>
                  <option value='am'<?php echo esc_attr(check_selected("am", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AM')); ?></option>
                  <option value='ar'<?php echo esc_attr(check_selected("ar", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AR')); ?></option>
                  <option value='hy'<?php echo esc_attr(check_selected("hy", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HY')); ?></option>
                  <option value='az'<?php echo esc_attr(check_selected("az", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AZ')); ?></option>
                  <option value='eu'<?php echo esc_attr(check_selected("eu", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EU')); ?></option>
                  <option value='be'<?php echo esc_attr(check_selected("be", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BE')); ?></option>
                  <option value='bn'<?php echo esc_attr(check_selected("bn", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BN')); ?></option>
                  <option value='bs'<?php echo esc_attr(check_selected("bs", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BS')); ?></option>
                  <option value='bg'<?php echo esc_attr(check_selected("bg", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BG')); ?></option>
                  <option value='ca'<?php echo esc_attr(check_selected("ca", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CA')); ?></option>
                  <option value='ceb'<?php echo esc_attr(check_selected("ceb", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CEB')); ?></option>
                  <option value='ny'<?php echo esc_attr(check_selected("ny", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NY')); ?></option>
                  <option value='zh'<?php echo esc_attr(check_selected("zh", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZH')); ?></option>
                  <option value='zt'<?php echo esc_attr(check_selected("zt", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZT')); ?></option>
                  <option value='co'<?php echo esc_attr(check_selected("co", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CO')); ?></option>
                  <option value='hr'<?php echo esc_attr(check_selected("hr", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HR')); ?></option>
                  <option value='cs'<?php echo esc_attr(check_selected("cs", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CS')); ?></option>
                  <option value='da'<?php echo esc_attr(check_selected("da", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DA')); ?></option>
                  <option value='nl'<?php echo esc_attr(check_selected("nl", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NL')); ?></option>
                  <option value='en'<?php echo esc_attr(check_selected("en", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EN')); ?></option>
                  <option value='eo'<?php echo esc_attr(check_selected("eo", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EO')); ?></option>
                  <option value='et'<?php echo esc_attr(check_selected("et", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ET')); ?></option>
                  <option value='tl'<?php echo esc_attr(check_selected("tl", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TL')); ?></option>
                  <option value='fi'<?php echo esc_attr(check_selected("fi", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FI')); ?></option>
                  <option value='fr'<?php echo esc_attr(check_selected("fr", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FR')); ?></option>
                  <option value='fy'<?php echo esc_attr(check_selected("fy", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FY')); ?></option>
                  <option value='gl'<?php echo esc_attr(check_selected("gl", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GL')); ?></option>
                  <option value='ka'<?php echo esc_attr(check_selected("ka", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KA')); ?></option>
                  <option value='de'<?php echo esc_attr(check_selected("de", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DE')); ?></option>
                  <option value='el'<?php echo esc_attr(check_selected("el", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EL')); ?></option>
                  <option value='gu'<?php echo esc_attr(check_selected("gu", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GU')); ?></option>
                  <option value='ht'<?php echo esc_attr(check_selected("ht", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HT')); ?></option>
                  <option value='ha'<?php echo esc_attr(check_selected("ha", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HA')); ?></option>
                  <option value='haw'<?php echo esc_attr(check_selected("haw", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HAW')); ?></option>
                  <option value='iw'<?php echo esc_attr(check_selected("iw", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IW')); ?></option>
                  <option value='hi'<?php echo esc_attr(check_selected("hi", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HI')); ?></option>
                  <option value='hmn'<?php echo esc_attr(check_selected("hmn", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HMN')); ?></option>
                  <option value='hu'<?php echo esc_attr(check_selected("hu", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HU')); ?></option>
                  <option value='is'<?php echo esc_attr(check_selected("is", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IS')); ?></option>
                  <option value='ig'<?php echo esc_attr(check_selected("ig", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IG')); ?></option>
                  <option value='id'<?php echo esc_attr(check_selected("id", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ID')); ?></option>
                  <option value='ga'<?php echo esc_attr(check_selected("ga", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GA')); ?></option>
                  <option value='it'<?php echo esc_attr(check_selected("it", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IT')); ?></option>
                  <option value='ja'<?php echo esc_attr(check_selected("ja", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JA')); ?></option>
                  <option value='jw'<?php echo esc_attr(check_selected("jw", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JW')); ?></option>
                  <option value='kn'<?php echo esc_attr(check_selected("kn", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KN')); ?></option>
                  <option value='kk'<?php echo esc_attr(check_selected("kk", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KK')); ?></option>
                  <option value='km'<?php echo esc_attr(check_selected("km", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KM')); ?></option>
                  <option value='ko'<?php echo esc_attr(check_selected("ko", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KO')); ?></option>
                  <option value='ku'<?php echo esc_attr(check_selected("ku", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KU')); ?></option>
                  <option value='ky'<?php echo esc_attr(check_selected("ky", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KY')); ?></option>
                  <option value='lo'<?php echo esc_attr(check_selected("lo", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LO')); ?></option>
                  <option value='la'<?php echo esc_attr(check_selected("la", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LA')); ?></option>
                  <option value='lv'<?php echo esc_attr(check_selected("lv", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LV')); ?></option>
                  <option value='lt'<?php echo esc_attr(check_selected("lt", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LT')); ?></option>
                  <option value='lb'<?php echo esc_attr(check_selected("lb", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LB')); ?></option>
                  <option value='mk'<?php echo esc_attr(check_selected("mk", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MK')); ?></option>
                  <option value='mg'<?php echo esc_attr(check_selected("mg", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MG')); ?></option>
                  <option value='ms'<?php echo esc_attr(check_selected("ms", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MS')); ?></option>
                  <option value='ml'<?php echo esc_attr(check_selected("ml", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ML')); ?></option>
                  <option value='mt'<?php echo esc_attr(check_selected("mt", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MT')); ?></option>
                  <option value='mi'<?php echo esc_attr(check_selected("mi", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MI')); ?></option>
                  <option value='mr'<?php echo esc_attr(check_selected("mr", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MR')); ?></option>
                  <option value='mn'<?php echo esc_attr(check_selected("mn", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MN')); ?></option>
                  <option value='my'<?php echo esc_attr(check_selected("my", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MY')); ?></option>
                  <option value='ne'<?php echo esc_attr(check_selected("ne", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NE')); ?></option>
                  <option value='no'<?php echo esc_attr(check_selected("no", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NO')); ?></option>
                  <option value='ps'<?php echo esc_attr(check_selected("ps", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PS')); ?></option>
                  <option value='fa'<?php echo esc_attr(check_selected("fa", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FA')); ?></option>
                  <option value='pl'<?php echo esc_attr(check_selected("pl", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PL')); ?></option>
                  <option value='pt'<?php echo esc_attr(check_selected("pt", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PT')); ?></option>
                  <option value='pa'<?php echo esc_attr(check_selected("pa", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PA')); ?></option>
                  <option value='ro'<?php echo esc_attr(check_selected("ro", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RO')); ?></option>
                  <option value='ru'<?php echo esc_attr(check_selected("ru", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RU')); ?></option>
                  <option value='sm'<?php echo esc_attr(check_selected("sm", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SM')); ?></option>
                  <option value='gd'<?php echo esc_attr(check_selected("gd", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GD')); ?></option>
                  <option value='sr'<?php echo esc_attr(check_selected("sr", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SR')); ?></option>
                  <option value='st'<?php echo esc_attr(check_selected("st", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ST')); ?></option>
                  <option value='sn'<?php echo esc_attr(check_selected("sn", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SN')); ?></option>
                  <option value='sd'<?php echo esc_attr(check_selected("sd", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SD')); ?></option>
                  <option value='si'<?php echo esc_attr(check_selected("si", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SI')); ?></option>
                  <option value='sk'<?php echo esc_attr(check_selected("sk", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SK')); ?></option>
                  <option value='sl'<?php echo esc_attr(check_selected("sl", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SL')); ?></option>
                  <option value='so'<?php echo esc_attr(check_selected("so", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SO')); ?></option>
                  <option value='es'<?php echo esc_attr(check_selected("es", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ES')); ?></option>
                  <option value='su'<?php echo esc_attr(check_selected("su", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SU')); ?></option>
                  <option value='sw'<?php echo esc_attr(check_selected("sw", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SW')); ?></option>
                  <option value='sv'<?php echo esc_attr(check_selected("sv", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SV')); ?></option>
                  <option value='tg'<?php echo esc_attr(check_selected("tg", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TG')); ?></option>
                  <option value='ta'<?php echo esc_attr(check_selected("ta", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TA')); ?></option>
                  <option value='te'<?php echo esc_attr(check_selected("te", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TE')); ?></option>
                  <option value='th'<?php echo esc_attr(check_selected("th", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TH')); ?></option>
                  <option value='tr'<?php echo esc_attr(check_selected("tr", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TR')); ?></option>
                  <option value='uk'<?php echo esc_attr(check_selected("uk", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UK')); ?></option>
                  <option value='ur'<?php echo esc_attr(check_selected("ur", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UR')); ?></option>
                  <option value='uz'<?php echo esc_attr(check_selected("uz", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UZ')); ?></option>
                  <option value='vi'<?php echo esc_attr(check_selected("vi", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_VI')); ?></option>
                  <option value='cy'<?php echo esc_attr(check_selected("cy", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CY')); ?></option>
                  <option value='xh'<?php echo esc_attr(check_selected("xh", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_XH')); ?></option>
                  <option value='yi'<?php echo esc_attr(check_selected("yi", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YI')); ?></option>
                  <option value='yo'<?php echo esc_attr(check_selected("yo", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YO')); ?></option>
                  <option value='zu'<?php echo esc_attr(check_selected("zu", $languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZU')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLED_LANGUAGES_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='detect_current_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_CURRENT_LANGUAGE')); ?></label></th>
            <td>
				<div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[detect_current_language]" value='1'<?php esc_html(checked($options["detect_current_language"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[detect_current_language]" value='0'<?php esc_html(checked($options["detect_current_language"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               </div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_CURRENT_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='detect_default_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_DEFAULT_LANGUAGE')); ?></label></th>
            <td>
				<div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[detect_default_language]" value='1'<?php esc_html(checked($options["detect_default_language"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[detect_default_language]" value='0'<?php esc_html(checked($options["detect_default_language"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               </div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_DEFAULT_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='detect_browser_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_BROWSER_LANGUAGE')); ?></label></th>
            <td>
				<div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[detect_browser_language]" value='1'<?php esc_html(checked($options["detect_browser_language"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[detect_browser_language]" value='0'<?php esc_html(checked($options["detect_browser_language"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               </div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DETECT_BROWSER_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='default_language_first'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DEFAULT_LANGUAGE_FIRST')); ?></label></th>
            <td>
	            <div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[default_language_first]" value='1'<?php esc_html(checked($options["default_language_first"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[default_language_first]" value='0'<?php esc_html(checked($options["default_language_first"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DEFAULT_LANGUAGE_FIRST_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='autotranslate_detected_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_AUTOTRANSLATE_DETECTED_LANGUAGE')); ?></label></th>
            <td>
            	<div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[autotranslate_detected_language]" value='1'<?php esc_html(checked($options["autotranslate_detected_language"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[autotranslate_detected_language]" value='0'<?php esc_html(checked($options["autotranslate_detected_language"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
				</div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_AUTOTRANSLATE_DETECTED_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='always_detect_autotranslated_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALWAYS_DETECT_AUTOTRANSLATED_LANGUAGE')); ?></label></th>
            <td>
				<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[always_detect_autotranslated_language]" value='1'<?php esc_html(checked($options["always_detect_autotranslated_language"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[always_detect_autotranslated_language]" value='0'<?php esc_html(checked($options["always_detect_autotranslated_language"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
				</div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALWAYS_DETECT_AUTOTRANSLATED_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='auto_set_language_direction'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_AUTO_SET_LANGUAGE_DIRECTION')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[auto_set_language_direction]" value='1'<?php esc_html(checked($options["auto_set_language_direction"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[auto_set_language_direction]" value='0'<?php esc_html(checked($options["auto_set_language_direction"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
				</div>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_AUTO_SET_LANGUAGE_DIRECTION_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='alt_flags'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAGS')); ?></label></th>
            <td>
            	<?php 
            	// Check if the value is in the array
            	function check_selected($value, $languages_array) {
            		return in_array($value, $languages_array) ? ' selected' : '';
            	}
            	
            	// Convert the string to an array
            	$altflags_array = isset($options["alt_flags"]) && is_array($options["alt_flags"]) ? $options["alt_flags"] : [];
            	?>
               <select name="gptranslate_options[alt_flags][]" multiple size="10" id='alt_flags' class="select2-dropdown">
                  <option value='usa'<?php echo esc_attr(check_selected("usa", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_USA')); ?></option>
                  <option value='canada'<?php echo esc_attr(check_selected("canada", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_CANADA')); ?></option>
                  <option value='ireland'<?php echo esc_attr(check_selected("ireland", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_IRELAND')); ?></option>
                  <option value='brazil'<?php echo esc_attr(check_selected("brazil", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_BRAZIL')); ?></option>
                  <option value='mexico'<?php echo esc_attr(check_selected("mexico", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_MEXICO')); ?></option>
                  <option value='argentina'<?php echo esc_attr(check_selected("argentina", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_ARGENTINA')); ?></option>
                  <option value='colombia'<?php echo esc_attr(check_selected("colombia", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_COLOMBIA')); ?></option>
                  <option value='quebec'<?php echo esc_attr(check_selected("quebec", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_QUEBEC')); ?></option>
                  <option value='taiwan'<?php echo esc_attr(check_selected("taiwan", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_TAIWAN')); ?></option>
                  <option value='hongkong'<?php echo esc_attr(check_selected("hongkong", $altflags_array));?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAG_HONGKONG')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ALT_FLAGS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_URLREWRITING_SETTINGS')); ?></label></th>
            <td>
            </td>
		</tr>
         <tr>
            <th scope='row'><label for='rewrite_language_url'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_URL')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[rewrite_language_url]" value='1'<?php esc_html(checked($options["rewrite_language_url"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[rewrite_language_url]" value='0'<?php esc_html(checked($options["rewrite_language_url"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_URL_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='rewrite_language_alias'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_ALIAS')); ?></label></th>
            <td>
            	<div class="wrapper">
	               <label><input type='radio' name="gptranslate_options[rewrite_language_alias]" value='1'<?php esc_html(checked($options["rewrite_language_alias"] ?? "0", "1")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               <label><input type='radio' name="gptranslate_options[rewrite_language_alias]" value='0'<?php esc_html(checked($options["rewrite_language_alias"] ?? "0", "0")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_ALIAS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='rewrite_language_alias_original_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_ALIAS_ORIGINAL_LANGUAGE')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[rewrite_language_alias_original_language]" value='1'<?php esc_html(checked($options["rewrite_language_alias_original_language"] ?? "0", "1")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[rewrite_language_alias_original_language]" value='0'<?php esc_html(checked($options["rewrite_language_alias_original_language"] ?? "0", "0")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_LANGUAGE_ALIAS_ORIGINAL_LANGUAGE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='rewrite_page_links'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_PAGE_LINKS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[rewrite_page_links]" value='1'<?php esc_html(checked($options["rewrite_page_links"] ?? "0", "1")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[rewrite_page_links]" value='0'<?php esc_html(checked($options["rewrite_page_links"] ?? "0", "0")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
				</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REWRITE_PAGE_LINKS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='omit_prefix_original_language'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_OMIT_PREFIX_ORIGINAL_LANGUAGE')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[omit_prefix_original_language]" value='1'<?php esc_html(checked($options["omit_prefix_original_language"] ?? "0", "1")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[omit_prefix_original_language]" value='0'<?php esc_html(checked($options["omit_prefix_original_language"] ?? "0", "0")); ?> class="urlrewriting"> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_OMIT_PREFIX_ORIGINAL_LANGUAGE_DESC')); ?></p>
            </td>
		</tr>
		<tr>
            <th scope='row'><label for='words_leafnodes_excluded'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EXCLUDED_ALIAS_SLUGS')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[excluded_alias_slugs]"
                  id='excluded_alias_slugs'
                  value='<?php echo esc_attr($options["excluded_alias_slugs"] ?? ""); ?>'
                  class='large-text regular-text urlrewriting' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EXCLUDED_ALIAS_SLUGS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_METADATA_SETTINGS')); ?></label></th>
            <td>
            </td>
		</tr>
         <tr>
            <th scope='row'><label for='translate_metadata'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_METADATA')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[translate_metadata]" value='1'<?php esc_html(checked($options["translate_metadata"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[translate_metadata]" value='0'<?php esc_html(checked($options["translate_metadata"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_METADATA_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='set_html_lang'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SET_HTML_LANG')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[set_html_lang]" value='1'<?php esc_html(checked($options["set_html_lang"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
	               	<label><input type='radio' name="gptranslate_options[set_html_lang]" value='0'<?php esc_html(checked($options["set_html_lang"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SET_HTML_LANG_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='add_canonical'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ADD_CANONICAL')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[add_canonical]" value='1'<?php esc_html(checked($options["add_canonical"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[add_canonical]" value='0'<?php esc_html(checked($options["add_canonical"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ADD_CANONICAL_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='add_alternate'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ADD_ALTERNATE')); ?></label></th>
            <td>
            	<div class="wrapper">
	               	<label><input type='radio' name="gptranslate_options[add_alternate]" value='1'<?php esc_html(checked($options["add_alternate"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label> 
	               	<label><input type='radio' name="gptranslate_options[add_alternate]" value='0'<?php esc_html(checked($options["add_alternate"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ADD_ALTERNATE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='translate_placeholders'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_PLACEHOLDERS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[translate_placeholders]" value='1'<?php esc_html(checked($options["translate_placeholders"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[translate_placeholders]" value='0'<?php esc_html(checked($options["translate_placeholders"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_PLACEHOLDERS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='translate_altimages'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_ALT_IMAGES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[translate_altimages]" value='1'<?php esc_html(checked($options["translate_altimages"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[translate_altimages]" value='0'<?php esc_html(checked($options["translate_altimages"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_ALT_IMAGES_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='css_selector_classes_translate_altimages_excluded'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_CLASSES_TRANSLATE_ALTIMAGES_EXCLUDED')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[css_selector_classes_translate_altimages_excluded]" id='css_selector_classes_translate_altimages_excluded' value='<?php echo esc_attr($options["css_selector_classes_translate_altimages_excluded"] ?? ""); ?>' class='large-text regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_CLASSES_TRANSLATE_ALTIMAGES_EXCLUDED_DESC')); ?></p>
            </td>
         </tr>
		<tr>
            <th scope='row'><label for='translate_srcimages'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_SRC_IMAGES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[translate_srcimages]" value='1'<?php esc_html(checked($options["translate_srcimages"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[translate_srcimages]" value='0'<?php esc_html(checked($options["translate_srcimages"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
				</div>
               	<p class='description' id="translate_srcimages"><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_SRC_IMAGES_DESC')); ?></p>
            </td>
		</tr>
         <tr>
            <th scope='row'><label for='translate_titles'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_TITLES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[translate_titles]" value='1'<?php esc_html(checked($options["translate_titles"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[translate_titles]" value='0'<?php esc_html(checked($options["translate_titles"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_TITLES_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='translate_values'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_VALUES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[translate_values]" value='1'<?php esc_html(checked($options["translate_values"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[translate_values]" value='0'<?php esc_html(checked($options["translate_values"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATE_VALUES_DESC')); ?></p>
            </td>
         </tr>
		 <tr>
            <th scope='row'><label for='metadata_chosen_engine'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_METADATA_CHOSEN_ENGINE')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[metadata_chosen_engine]" value='1'<?php esc_html(checked($options["metadata_chosen_engine"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[metadata_chosen_engine]" value='0'<?php esc_html(checked($options["metadata_chosen_engine"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_METADATA_CHOSEN_ENGINE_DESC')); ?></p>
            </td>
         </tr>
		<tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_SERVERSIDE_SETTINGS')); ?></label></th>
            <td>
            </td>
		</tr>
		
         <tr>
            <th scope='row'><label for='serverside_translations'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations]" value='1'<?php esc_html(checked($options["serverside_translations"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[serverside_translations]" value='0'<?php esc_html(checked($options["serverside_translations"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='serverside_translations_method'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD')); ?></label></th>
            <td>
               	<select name="gptranslate_options[serverside_translations_method]" id='serverside_translations_method' class="serverside_translations">
				    <option value='regex'<?php selected($options["serverside_translations_method"] ?? "regex", "regex"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD_REGEX')); ?></option>
				    <option value='domdocument'<?php selected($options["serverside_translations_method"] ?? "regex", "domdocument"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD_DOMDOCUMENT')); ?></option>
				    <option value='simplehtmldom'<?php selected($options["serverside_translations_method"] ?? "regex", "simplehtmldom"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD_SIMPLEHTMLDOM')); ?></option>
				    <option value='strireplace'<?php selected($options["serverside_translations_method"] ?? "regex", "strireplace"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD_STRIREPLACE')); ?></option>
				</select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_METHOD_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='serverside_translations_caseinsensitive'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_CASEINSENSITIVE')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations_caseinsensitive]" class="serverside_translations" value='1'<?php esc_html(checked($options["serverside_translations_caseinsensitive"] ?? "1", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[serverside_translations_caseinsensitive]" class="serverside_translations" value='0'<?php esc_html(checked($options["serverside_translations_caseinsensitive"] ?? "1", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_CASEINSENSITIVE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='serverside_translations_matchquotes'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_MATCHQUOTES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations_matchquotes]" class="serverside_translations" value='1'<?php esc_html(checked($options["serverside_translations_matchquotes"] ?? "1", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
					<label><input type='radio' name="gptranslate_options[serverside_translations_matchquotes]" class="serverside_translations" value='0'<?php esc_html(checked($options["serverside_translations_matchquotes"] ?? "1", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_MATCHQUOTES_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='serverside_translations_urldecode'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_URLDECODE')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations_urldecode]" class="serverside_translations" value='1'<?php esc_html(checked($options["serverside_translations_urldecode"] ?? "1", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[serverside_translations_urldecode]" class="serverside_translations" value='0'<?php esc_html(checked($options["serverside_translations_urldecode"] ?? "1", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_URLDECODE_DESC')); ?></p>
            </td>
         </tr>
		 <tr>
			<th scope='row'><label for='serverside_translations_language_switching_mode'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_LANGUAGE_SWITCHING_MODE')); ?></label></th>
			<td>
				<select name="gptranslate_options[serverside_translations_language_switching_mode]" id='serverside_translations_language_switching_mode' class="serverside_translations">
					<option value='url'<?php selected($options["serverside_translations_language_switching_mode"] ?? "url", "url"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_LANGUAGE_SWITCHING_MODE_URL')); ?></option>
					<option value='storage'<?php selected($options["serverside_translations_language_switching_mode"] ?? "url", "storage"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_LANGUAGE_SWITCHING_MODE_STORAGE')); ?></option>
				</select>
				<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_LANGUAGE_SWITCHING_MODE_DESC')); ?></p>
			</td>
		</tr>
		<tr>
            <th scope='row'><label
               for='serverside_translations_ignore_querystring'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_IGNORE_QUERYSTRING')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations_ignore_querystring]" class="serverside_translations" value='1'<?php esc_html(checked($options["serverside_translations_ignore_querystring"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[serverside_translations_ignore_querystring]" class="serverside_translations" value='0'<?php esc_html(checked($options["serverside_translations_ignore_querystring"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_IGNORE_QUERYSTRING_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='serverside_translations_urlencode_space'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_URLENCODE_SPACE')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[serverside_translations_urlencode_space]" class="serverside_translations" value='1'<?php esc_html(checked($options["serverside_translations_urlencode_space"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[serverside_translations_urlencode_space]" class="serverside_translations" value='0'<?php esc_html(checked($options["serverside_translations_urlencode_space"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_URLENCODE_SPACE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label
               for='css_selector_serverside_leafnodes_excluded'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_CSS_SELECTOR_LEAFNODES_EXCLUDED')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[css_selector_serverside_leafnodes_excluded]" id='css_selector_serverside_leafnodes_excluded' class='large-text serverside_translations' rows='5'><?php echo esc_textarea($options["css_selector_serverside_leafnodes_excluded"] ?? ""); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SERVERSIDE_TRANSLATIONS_CSS_SELECTOR_LEAFNODES_EXCLUDED_DESC')); ?></p>
            </td>
         </tr>
 		 <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_DICTIONARY_EXCLUSIONS_SETTINGS')); ?></label></th>
            <td>
            </td>
		 </tr>
         <tr>
            <th scope='row'><label for='css_selector_leafnodes_excluded'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_LEAFNODES_EXCLUDED')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[css_selector_leafnodes_excluded]"
                  id='css_selector_leafnodes_excluded' class='large-text' rows='5'><?php echo esc_textarea($options["css_selector_leafnodes_excluded"] ?? ""); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_LEAFNODES_EXCLUDED_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='words_leafnodes_excluded'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[words_leafnodes_excluded]"
                  id='words_leafnodes_excluded'
                  value='<?php echo esc_attr($options["words_leafnodes_excluded"] ?? ""); ?>'
                  class='large-text regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED_DESC')); ?></p>
            </td>
         </tr>
         <tr>
		    <th scope='row'>
		        <label for='words_leafnodes_excluded_bylanguage_repeatable'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED_BYLANGUAGE_REPEATABLE')); ?></label>
		    </th>
		    <td>
		        <table class="widefat" id="words_leafnodes_excluded_bylanguage_repeatable-table">
		            <thead>
		                <tr>
		                    <th><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED')); ?></th>
		                    <th><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ORIGINAL_LANGUAGE')); ?></th>
		                    <th><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATED_LANGUAGE')); ?></th>
		                    <th><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED_TRANSLATION')); ?></th>
		                    <th><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ACTIONS')); ?> <button type="button" class="button button-secondary" id="add-repeatable-row"><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ADD_ROW')); ?></button></th>
		                </tr>
		            </thead>
		            <tbody id="words_leafnodes_excluded_bylanguage_repeatable-body">
		                <!-- Righe dinamiche JS -->
		            </tbody>
		        </table>
		        <p class="description"><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_LEAFNODES_EXCLUDED_BYLANGUAGE_REPEATABLE_DESC')); ?></p>
		        <input type="hidden" name="gptranslate_options[words_leafnodes_excluded_bylanguage_repeatable]" id="words_leafnodes_excluded_bylanguage_repeatable" value='<?php echo esc_attr(get_option("gptranslate_options")["words_leafnodes_excluded_bylanguage_repeatable"] ?? ""); ?>'>
		    </td>
		</tr>
		<tr>
            <th scope='row'><label for='words_min_length'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_MIN_LENGTH')); ?></label></th>
            <td>
               <input type='number' name="gptranslate_options[words_min_length]"
                  id='words_min_length'
                  value='<?php echo esc_attr($options["words_min_length"] ?? ""); ?>' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WORDS_MIN_LENGTH_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='excluded_languages'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EXCLUDED_LANGUAGES')); ?></label></th>
            <td>
            	<?php 
            	// Convert the string to an array
            	$excluded_languages_array = $options['excluded_languages'] ?? [];
            	?>
               <select name="gptranslate_options[excluded_languages][]" multiple size="20" id='excluded_languages' class="select2-dropdown">
				  <option value='af'<?php echo esc_attr(check_selected("af", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AF')); ?></option>
                  <option value='sq'<?php echo esc_attr(check_selected("sq", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SQ')); ?></option>
                  <option value='am'<?php echo esc_attr(check_selected("am", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AM')); ?></option>
                  <option value='ar'<?php echo esc_attr(check_selected("ar", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AR')); ?></option>
                  <option value='hy'<?php echo esc_attr(check_selected("hy", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HY')); ?></option>
                  <option value='az'<?php echo esc_attr(check_selected("az", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_AZ')); ?></option>
                  <option value='eu'<?php echo esc_attr(check_selected("eu", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EU')); ?></option>
                  <option value='be'<?php echo esc_attr(check_selected("be", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BE')); ?></option>
                  <option value='bn'<?php echo esc_attr(check_selected("bn", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BN')); ?></option>
                  <option value='bs'<?php echo esc_attr(check_selected("bs", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BS')); ?></option>
                  <option value='bg'<?php echo esc_attr(check_selected("bg", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_BG')); ?></option>
                  <option value='ca'<?php echo esc_attr(check_selected("ca", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CA')); ?></option>
                  <option value='ceb'<?php echo esc_attr(check_selected("ceb", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CEB')); ?></option>
                  <option value='ny'<?php echo esc_attr(check_selected("ny", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NY')); ?></option>
                  <option value='zh'<?php echo esc_attr(check_selected("zh", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZH')); ?></option>
                  <option value='zt'<?php echo esc_attr(check_selected("zt", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZT')); ?></option>
                  <option value='co'<?php echo esc_attr(check_selected("co", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CO')); ?></option>
                  <option value='hr'<?php echo esc_attr(check_selected("hr", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HR')); ?></option>
                  <option value='cs'<?php echo esc_attr(check_selected("cs", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CS')); ?></option>
                  <option value='da'<?php echo esc_attr(check_selected("da", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DA')); ?></option>
                  <option value='nl'<?php echo esc_attr(check_selected("nl", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NL')); ?></option>
                  <option value='en'<?php echo esc_attr(check_selected("en", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EN')); ?></option>
                  <option value='eo'<?php echo esc_attr(check_selected("eo", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EO')); ?></option>
                  <option value='et'<?php echo esc_attr(check_selected("et", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ET')); ?></option>
                  <option value='tl'<?php echo esc_attr(check_selected("tl", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TL')); ?></option>
                  <option value='fi'<?php echo esc_attr(check_selected("fi", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FI')); ?></option>
                  <option value='fr'<?php echo esc_attr(check_selected("fr", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FR')); ?></option>
                  <option value='fy'<?php echo esc_attr(check_selected("fy", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FY')); ?></option>
                  <option value='gl'<?php echo esc_attr(check_selected("gl", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GL')); ?></option>
                  <option value='ka'<?php echo esc_attr(check_selected("ka", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KA')); ?></option>
                  <option value='de'<?php echo esc_attr(check_selected("de", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_DE')); ?></option>
                  <option value='el'<?php echo esc_attr(check_selected("el", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_EL')); ?></option>
                  <option value='gu'<?php echo esc_attr(check_selected("gu", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GU')); ?></option>
                  <option value='ht'<?php echo esc_attr(check_selected("ht", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HT')); ?></option>
                  <option value='ha'<?php echo esc_attr(check_selected("ha", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HA')); ?></option>
                  <option value='haw'<?php echo esc_attr(check_selected("haw", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HAW')); ?></option>
                  <option value='iw'<?php echo esc_attr(check_selected("iw", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IW')); ?></option>
                  <option value='hi'<?php echo esc_attr(check_selected("hi", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HI')); ?></option>
                  <option value='hmn'<?php echo esc_attr(check_selected("hmn", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HMN')); ?></option>
                  <option value='hu'<?php echo esc_attr(check_selected("hu", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_HU')); ?></option>
                  <option value='is'<?php echo esc_attr(check_selected("is", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IS')); ?></option>
                  <option value='ig'<?php echo esc_attr(check_selected("ig", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IG')); ?></option>
                  <option value='id'<?php echo esc_attr(check_selected("id", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ID')); ?></option>
                  <option value='ga'<?php echo esc_attr(check_selected("ga", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GA')); ?></option>
                  <option value='it'<?php echo esc_attr(check_selected("it", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_IT')); ?></option>
                  <option value='ja'<?php echo esc_attr(check_selected("ja", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JA')); ?></option>
                  <option value='jw'<?php echo esc_attr(check_selected("jw", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_JW')); ?></option>
                  <option value='kn'<?php echo esc_attr(check_selected("kn", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KN')); ?></option>
                  <option value='kk'<?php echo esc_attr(check_selected("kk", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KK')); ?></option>
                  <option value='km'<?php echo esc_attr(check_selected("km", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KM')); ?></option>
                  <option value='ko'<?php echo esc_attr(check_selected("ko", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KO')); ?></option>
                  <option value='ku'<?php echo esc_attr(check_selected("ku", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KU')); ?></option>
                  <option value='ky'<?php echo esc_attr(check_selected("ky", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_KY')); ?></option>
                  <option value='lo'<?php echo esc_attr(check_selected("lo", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LO')); ?></option>
                  <option value='la'<?php echo esc_attr(check_selected("la", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LA')); ?></option>
                  <option value='lv'<?php echo esc_attr(check_selected("lv", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LV')); ?></option>
                  <option value='lt'<?php echo esc_attr(check_selected("lt", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LT')); ?></option>
                  <option value='lb'<?php echo esc_attr(check_selected("lb", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_LB')); ?></option>
                  <option value='mk'<?php echo esc_attr(check_selected("mk", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MK')); ?></option>
                  <option value='mg'<?php echo esc_attr(check_selected("mg", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MG')); ?></option>
                  <option value='ms'<?php echo esc_attr(check_selected("ms", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MS')); ?></option>
                  <option value='ml'<?php echo esc_attr(check_selected("ml", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ML')); ?></option>
                  <option value='mt'<?php echo esc_attr(check_selected("mt", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MT')); ?></option>
                  <option value='mi'<?php echo esc_attr(check_selected("mi", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MI')); ?></option>
                  <option value='mr'<?php echo esc_attr(check_selected("mr", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MR')); ?></option>
                  <option value='mn'<?php echo esc_attr(check_selected("mn", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MN')); ?></option>
                  <option value='my'<?php echo esc_attr(check_selected("my", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_MY')); ?></option>
                  <option value='ne'<?php echo esc_attr(check_selected("ne", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NE')); ?></option>
                  <option value='no'<?php echo esc_attr(check_selected("no", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_NO')); ?></option>
                  <option value='ps'<?php echo esc_attr(check_selected("ps", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PS')); ?></option>
                  <option value='fa'<?php echo esc_attr(check_selected("fa", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_FA')); ?></option>
                  <option value='pl'<?php echo esc_attr(check_selected("pl", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PL')); ?></option>
                  <option value='pt'<?php echo esc_attr(check_selected("pt", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PT')); ?></option>
                  <option value='pa'<?php echo esc_attr(check_selected("pa", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_PA')); ?></option>
                  <option value='ro'<?php echo esc_attr(check_selected("ro", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RO')); ?></option>
                  <option value='ru'<?php echo esc_attr(check_selected("ru", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_RU')); ?></option>
                  <option value='sm'<?php echo esc_attr(check_selected("sm", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SM')); ?></option>
                  <option value='gd'<?php echo esc_attr(check_selected("gd", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_GD')); ?></option>
                  <option value='sr'<?php echo esc_attr(check_selected("sr", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SR')); ?></option>
                  <option value='st'<?php echo esc_attr(check_selected("st", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ST')); ?></option>
                  <option value='sn'<?php echo esc_attr(check_selected("sn", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SN')); ?></option>
                  <option value='sd'<?php echo esc_attr(check_selected("sd", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SD')); ?></option>
                  <option value='si'<?php echo esc_attr(check_selected("si", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SI')); ?></option>
                  <option value='sk'<?php echo esc_attr(check_selected("sk", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SK')); ?></option>
                  <option value='sl'<?php echo esc_attr(check_selected("sl", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SL')); ?></option>
                  <option value='so'<?php echo esc_attr(check_selected("so", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SO')); ?></option>
                  <option value='es'<?php echo esc_attr(check_selected("es", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ES')); ?></option>
                  <option value='su'<?php echo esc_attr(check_selected("su", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SU')); ?></option>
                  <option value='sw'<?php echo esc_attr(check_selected("sw", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SW')); ?></option>
                  <option value='sv'<?php echo esc_attr(check_selected("sv", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_SV')); ?></option>
                  <option value='tg'<?php echo esc_attr(check_selected("tg", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TG')); ?></option>
                  <option value='ta'<?php echo esc_attr(check_selected("ta", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TA')); ?></option>
                  <option value='te'<?php echo esc_attr(check_selected("te", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TE')); ?></option>
                  <option value='th'<?php echo esc_attr(check_selected("th", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TH')); ?></option>
                  <option value='tr'<?php echo esc_attr(check_selected("tr", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_TR')); ?></option>
                  <option value='uk'<?php echo esc_attr(check_selected("uk", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UK')); ?></option>
                  <option value='ur'<?php echo esc_attr(check_selected("ur", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UR')); ?></option>
                  <option value='uz'<?php echo esc_attr(check_selected("uz", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_UZ')); ?></option>
                  <option value='vi'<?php echo esc_attr(check_selected("vi", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_VI')); ?></option>
                  <option value='cy'<?php echo esc_attr(check_selected("cy", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_CY')); ?></option>
                  <option value='xh'<?php echo esc_attr(check_selected("xh", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_XH')); ?></option>
                  <option value='yi'<?php echo esc_attr(check_selected("yi", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YI')); ?></option>
                  <option value='yo'<?php echo esc_attr(check_selected("yo", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_YO')); ?></option>
                  <option value='zu'<?php echo esc_attr(check_selected("zu", $excluded_languages_array)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_LANGUAGE_NAME_ZU')); ?></option>
               </select>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EXCLUDED_LANGUAGES_DESC')); ?></p>
            </td>
         </tr>
		 <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_ADVANCED_SETTINGS')); ?></label></th>
            <td>
            </td>
		 </tr>
		 <tr>
            <th scope='row'><label for='crawler_timeout'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CRAWLER_TIMEOUT')); ?></label></th>
            <td>
               <input type='number' name="gptranslate_options[crawler_timeout]"
                  id='crawler_timeout'
                  value='<?php echo esc_attr($options["crawler_timeout"] ?? "30"); ?>' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CRAWLER_TIMEOUT_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='crawler_exclusions'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CRAWLER_EXCLUSIONS')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[crawler_exclusions]"
                  id='crawler_exclusions' class='large-text' rows='5'><?php echo esc_textarea($options["crawler_exclusions"] ?? ""); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CRAWLER_EXCLUSIONS_DESC')); ?></p>
            </td>
         </tr>
		 <tr>
            <th scope='row'><label for='page_exclusions'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_PAGE_EXCLUSIONS')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[page_exclusions]"
                  id='page_exclusions' class='large-text' rows='5'><?php echo esc_textarea($options["page_exclusions"] ?? ""); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_PAGE_EXCLUSIONS_DESC')); ?></p>
            </td>
         </tr> 
         <tr>
            <th scope='row'><label for='chatgpt_gtranslate_request_delay'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY')); ?></label></th>
            <td>
               <select name="gptranslate_options[chatgpt_gtranslate_request_delay]"
                  id='chatgpt_gtranslate_request_delay'>
                  <option value='0'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "0"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_NODELAY')); ?></option>
                  <option value='5'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "5"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_VERYFAST')); ?></option>
                  <option value='10'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "10"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_FAST')); ?></option>
                  <option value='50'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "50"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_MEDIUM')); ?></option>
                  <option value='100'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "100"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_SLOW')); ?></option>
                  <option value='200'<?php
                     selected($options["chatgpt_gtranslate_request_delay"] ?? "0",
                     "200"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_VERYSLOW')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REQUEST_DELAY_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='initial_translation_delay'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY')); ?></label></th>
            <td>
               <select name="gptranslate_options[initial_translation_delay]"
                  id='initial_translation_delay'>
                  <option value='0'<?php
                     selected($options["initial_translation_delay"] ?? "0", "0");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_NONE')); ?></option>
                  <option value='10'<?php
                     selected($options["initial_translation_delay"] ?? "0", "10");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_10')); ?></option>
                  <option value='25'<?php
                     selected($options["initial_translation_delay"] ?? "0", "25");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_25')); ?></option>
                  <option value='50'<?php
                     selected($options["initial_translation_delay"] ?? "0", "50");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_50')); ?></option>
                  <option value='75'<?php
                     selected($options["initial_translation_delay"] ?? "0", "75");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_75')); ?></option>
                  <option value='100'<?php
                     selected($options["initial_translation_delay"] ?? "0", "100");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_100')); ?></option>
                  <option value='200'<?php
                     selected($options["initial_translation_delay"] ?? "0", "200");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_200')); ?></option>
                  <option value='300'<?php
                     selected($options["initial_translation_delay"] ?? "0", "300");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_300')); ?></option>
                  <option value='400'<?php
                     selected($options["initial_translation_delay"] ?? "0", "400");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_400')); ?></option>
                  <option value='500'<?php
                     selected($options["initial_translation_delay"] ?? "0", "500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_500')); ?></option>
                  <option value='600'<?php
                     selected($options["initial_translation_delay"] ?? "0", "600");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_600')); ?></option>
                  <option value='700'<?php
                     selected($options["initial_translation_delay"] ?? "0", "700");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_700')); ?></option>
                  <option value='800'<?php
                     selected($options["initial_translation_delay"] ?? "0", "800");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_800')); ?></option>
                  <option value='900'<?php
                     selected($options["initial_translation_delay"] ?? "0", "900");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_900')); ?></option>
                  <option value='1000'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1000')); ?></option>
                  <option value='1100'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1100");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1100')); ?></option>
                  <option value='1200'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1200");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1200')); ?></option>
                  <option value='1300'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1300");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1300')); ?></option>
                  <option value='1400'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1400");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1400')); ?></option>
                  <option value='1500'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1500')); ?></option>
                  <option value='1600'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1600");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1600')); ?></option>
                  <option value='1700'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1700");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1700')); ?></option>
                  <option value='1800'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1800");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1800')); ?></option>
                  <option value='1900'<?php
                     selected($options["initial_translation_delay"] ?? "0", "1900");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1900')); ?></option>
                  <option value='2000'<?php
                     selected($options["initial_translation_delay"] ?? "0", "2000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_2000')); ?></option>
                  <option value='2500'<?php
                     selected($options["initial_translation_delay"] ?? "0", "2500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_2500')); ?></option>
                  <option value='3000'<?php
                     selected($options["initial_translation_delay"] ?? "0", "3000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_3000')); ?></option>
                  <option value='3500'<?php
                     selected($options["initial_translation_delay"] ?? "0", "3500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_3500')); ?></option>
                  <option value='4000'<?php
                     selected($options["initial_translation_delay"] ?? "0", "4000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_4000')); ?></option>
                  <option value='4500'<?php
                     selected($options["initial_translation_delay"] ?? "0", "4500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_4500')); ?></option>
                  <option value='5000'<?php
                     selected($options["initial_translation_delay"] ?? "0", "5000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_5000')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='realtime_translations'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[realtime_translations]" value='1'<?php esc_html(checked($options["realtime_translations"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[realtime_translations]" value='0'<?php esc_html(checked($options["realtime_translations"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='css_selector_realtime_translations_retrigger'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_REALTIME_TRANSLATIONS_RETRIGGER')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[css_selector_realtime_translations_retrigger]" id='css_selector_realtime_translations_retrigger' value='<?php echo esc_attr($options["css_selector_realtime_translations_retrigger"] ?? ""); ?>' class='large-text regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_SELECTOR_REALTIME_TRANSLATIONS_RETRIGGER_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='realtime_translations_retrigger_events'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS')); ?></label></th>
            <td>
            	<?php 
            	// Convert the string to an array
            	$retrigger_events = $options['realtime_translations_retrigger_events'] ?? ['click'];
            	?>
               <select name="gptranslate_options[realtime_translations_retrigger_events][]" multiple size="20" id='realtime_translations_retrigger_events' class="select2-dropdown">
                  <option value='click'<?php echo esc_attr(check_selected("click", $retrigger_events)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_CLICK')); ?></option>
                  <option value='change'<?php echo esc_attr(check_selected("change", $retrigger_events)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_CHANGE')); ?></option>
                  <option value='mutation'<?php echo esc_attr(check_selected("mutation", $retrigger_events)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_MUTATION')); ?></option>
                  <option value='scroll'<?php echo esc_attr(check_selected("scroll", $retrigger_events)); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_SCROLL')); ?></option>
			   </select>
			    <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_DESC')); ?></p>
			</td>
		 </tr>
		 <tr>
            <th scope='row'><label for='realtime_translations_retrigger_events_delay'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_DELAY')); ?></label></th>
            <td>
               <select name="gptranslate_options[realtime_translations_retrigger_events_delay]"
                  id='realtime_translations_retrigger_events_delay'>
                  <option value='0'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "0");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_NONE')); ?></option>
                  <option value='10'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "10");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_10')); ?></option>
                  <option value='25'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "25");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_25')); ?></option>
                  <option value='50'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "50");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_50')); ?></option>
                  <option value='75'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "75");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_75')); ?></option>
                  <option value='100'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "100");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_100')); ?></option>
                  <option value='200'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "200");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_200')); ?></option>
                  <option value='300'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "300");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_300')); ?></option>
                  <option value='400'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "400");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_400')); ?></option>
                  <option value='500'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_500')); ?></option>
                  <option value='600'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "600");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_600')); ?></option>
                  <option value='700'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "700");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_700')); ?></option>
                  <option value='800'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "800");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_800')); ?></option>
                  <option value='900'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "900");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_900')); ?></option>
                  <option value='1000'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1000')); ?></option>
                  <option value='1100'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1100");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1100')); ?></option>
                  <option value='1200'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1200");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1200')); ?></option>
                  <option value='1300'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1300");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1300')); ?></option>
                  <option value='1400'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1400");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1400')); ?></option>
                  <option value='1500'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1500')); ?></option>
                  <option value='1600'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1600");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1600')); ?></option>
                  <option value='1700'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1700");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1700')); ?></option>
                  <option value='1800'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1800");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1800')); ?></option>
                  <option value='1900'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "1900");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_1900')); ?></option>
                  <option value='2000'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "2000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_2000')); ?></option>
                  <option value='2500'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "2500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_2500')); ?></option>
                  <option value='3000'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "3000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_3000')); ?></option>
                  <option value='3500'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "3500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_3500')); ?></option>
                  <option value='4000'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "4000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_4000')); ?></option>
                  <option value='4500'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "4500");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_4500')); ?></option>
                  <option value='5000'<?php
                     selected($options["realtime_translations_retrigger_events_delay"] ?? "200", "5000");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_INITIAL_TRANSLATION_DELAY_5000')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_REALTIME_TRANSLATIONS_RETRIGGER_EVENTS_DELAY_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='translations_export_format'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATIONS_EXPORT_FORMAT')); ?></label></th>
            <td>
               <select name="gptranslate_options[translations_export_format]" id='translations_export_format'>
                  <option value='.csv'<?php
                     selected($options["translations_export_format"] ?? ".csv",
                     ".csv"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATIONS_EXPORT_FORMAT_CSV')); ?></option>
                  <option value='.xliff'<?php
                     selected($options["translations_export_format"] ?? ".csv",
                     ".xliff"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATIONS_EXPORT_FORMAT_XLIFF')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_TRANSLATIONS_EXPORT_FORMAT_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='ignore_querystring'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_IGNORE_QUERYSTRING')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[ignore_querystring]" value='1'<?php esc_html(checked($options["ignore_querystring"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[ignore_querystring]" value='0'<?php esc_html(checked($options["ignore_querystring"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_IGNORE_QUERYSTRING_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='storage_type'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_STORAGE_TYPE')); ?></label></th>
            <td>
               <select name="gptranslate_options[storage_type]" id='storage_type'>
                  <option  value='session'<?php selected($options["storage_type"] ?? "session", "session"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_STORAGE_TYPE_SESSION')); ?></option>
                  <option value='local'<?php selected($options["storage_type"] ?? "session", "local"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_STORAGE_TYPE_LOCAL')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_STORAGE_TYPE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='subfolder_installation'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SUBFOLDER_INSTALLATION')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[subfolder_installation]" value='1'<?php esc_html(checked($options["subfolder_installation"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[subfolder_installation]" value='0'<?php esc_html(checked($options["subfolder_installation"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SUBFOLDER_INSTALLATION_DESC')); ?></p>
            </td>
         </tr>
      </table>
      <p><input type='submit' class='button-primary' value='<?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'></p>
	</div>
	<div id='tab-reader' class='tab-content' style='display: none;'>
      <p><input type='submit' class='button-primary' value='<?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'></p>
      <?php settings_fields('gptranslate_settings'); do_settings_sections('gptranslate'); ?>
      <table class='form-table'>
		 <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_READER_SETTINGS')); ?></label></th>
            <td>
            </td>
		 </tr>
         <tr>
            <th scope='row'><label for='enable_reader'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLE_READER')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[enable_reader]" value='1'<?php esc_html(checked($options["enable_reader"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label> 
               		<label><input type='radio' name="gptranslate_options[enable_reader]" value='0'<?php esc_html(checked($options["enable_reader"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLE_READER_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='responsivevoice_apikey'><?php echo wp_kses_post($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_APIKEY')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[responsivevoice_apikey]"
                  id='responsivevoice_apikey'
                  value='<?php echo esc_attr($options["responsivevoice_apikey"] ?? "kWyXm5dC"); ?>'
                  class='regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_APIKEY_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='responsivevoice_language_gender'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_LANGUAGE_GENDER')); ?></label></th>
            <td>
               <select name="gptranslate_options[responsivevoice_language_gender]"
                  id='responsivevoice_language_gender'>
                  <option value='auto'<?php
                     selected($options["responsivevoice_language_gender"] ?? "auto",
                     "auto"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_LANGUAGE_GENDER_AUTO')); ?></option>
                  <option value='male'<?php
                     selected($options["responsivevoice_language_gender"] ?? "auto",
                     "male"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_LANGUAGE_GENDER_MALE')); ?></option>
                  <option value='female'<?php
                     selected($options["responsivevoice_language_gender"] ?? "auto",
                     "female");
                     ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_LANGUAGE_GENDER_FEMALE')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_LANGUAGE_GENDER_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='responsivevoice_volume_tts'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOLUME')); ?></label></th>
            <td>
               <select name="gptranslate_options[responsivevoice_volume_tts]"
                  id='responsivevoice_volume_tts'>
                  <option value='20'<?php
                     selected($options["responsivevoice_volume_tts"] ?? "100", "20");
                     ?>>20%</option>
                  <option value='40'<?php
                     selected($options["responsivevoice_volume_tts"] ?? "100", "40");
                     ?>>40%</option>
                  <option value='60'<?php
                     selected($options["responsivevoice_volume_tts"] ?? "100", "60");
                     ?>>60%</option>
                  <option value='80'<?php
                     selected($options["responsivevoice_volume_tts"] ?? "100", "80");
                     ?>>80%</option>
                  <option value='100'<?php
                     selected($options["responsivevoice_volume_tts"] ?? "100", "100");
                     ?>>100%</option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOLUME_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='responsivevoice_voice_speed'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_VOICE_SPEED')); ?></label></th>
            <td>
               <select name="gptranslate_options[responsivevoice_voice_speed]"
                  id='responsivevoice_voice_speed'>
                  <option value='veryslow'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "veryslow"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_VERYSLOW')); ?></option>
                  <option value='slow'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "slow"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_SLOW')); ?></option>
                  <option value='normal'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "normal"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_NORMAL')); ?></option>
                  <option value='fast'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "fast"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_FAST')); ?></option>
                  <option value='veryfast'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "veryfast"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_VERYFAST')); ?></option>
                  <option value='extremelyfast'<?php
                     selected($options["responsivevoice_voice_speed"] ?? "normal",
                     "extremelyfast"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_VOICE_SPEED_EXTREMELYFAST')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_VOICE_SPEED_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='mainpage_selector'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAINPAGE_SELECTOR')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[mainpage_selector]"
                  id='mainpage_selector'
                  value='<?php echo esc_attr($options["mainpage_selector"] ?? "*[name*=main], *[class*=main], *[id*=main], *[id*=container], *[class*=container]"); ?>'
                  class='large-text regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_MAINPAGE_SELECTOR_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='elements_toexclude_custom'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ELEMENTS_TOEXCLUDE_CUSTOM')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[elements_toexclude_custom]"
                  id='elements_toexclude_custom'
                  value='<?php echo esc_attr($options["elements_toexclude_custom"] ?? ""); ?>'
                  class='large-text regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ELEMENTS_TOEXCLUDE_CUSTOM_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='proxy_responsive_loading_script'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVE_LOADING_SCRIPT')); ?></label></th>
            <td>
               <select name="gptranslate_options[proxy_responsive_loading_script]"
                  id='proxy_responsive_loading_script'>
                  <option value='1'<?php selected($options["proxy_responsive_loading_script"] ?? "1", "1"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVE_LOADING_SCRIPT_LOCAL')); ?></option>
                  <option value='0'<?php selected($options["proxy_responsive_loading_script"] ?? "1", "0"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVE_LOADING_SCRIPT_REMOTE')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVE_LOADING_SCRIPT_DESC')); ?></p>
            </td>
         </tr>
         
         <tr>
            <th scope='row'><label for='proxy_responsive_reading_mode'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_READING_MODE')); ?></label></th>
            <td>
               <select name="gptranslate_options[proxy_responsive_reading_mode]"
                  id='proxy_responsive_reading_mode'>
                  <option value='native'<?php selected($options["proxy_responsive_reading_mode"] ?? "native", "native"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_READING_MODE_NATIVE')); ?></option>
                  <option value='api'<?php selected($options["proxy_responsive_reading_mode"] ?? "native", "api"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_READING_MODE_API')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_RESPONSIVEVOICE_READING_MODE_DESC')); ?></p>
            </td>
         </tr>
         
         <tr>
            <th scope='row'><label for='chunksize'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHUNKSIZE')); ?></label></th>
            <td>
               <select name="gptranslate_options[chunksize]" id='chunksize'>
                  <option value='20'<?php selected($options["chunksize"] ?? "200", "20"); ?>>20</option>
                  <option value='40'<?php selected($options["chunksize"] ?? "200", "40"); ?>>40</option>
                  <option value='60'<?php selected($options["chunksize"] ?? "200", "60"); ?>>60</option>
                  <option value='80'<?php selected($options["chunksize"] ?? "200", "80"); ?>>80</option>
                  <option value='90'<?php selected($options["chunksize"] ?? "200", "90"); ?>>90</option>
                  <option value='100'<?php selected($options["chunksize"] ?? "200", "100"); ?>>100</option>
                  <option value='120'<?php selected($options["chunksize"] ?? "200", "120"); ?>>120</option>
                  <option value='140'<?php selected($options["chunksize"] ?? "200", "140"); ?>>140</option>
                  <option value='160'<?php selected($options["chunksize"] ?? "200", "160"); ?>>160</option>
                  <option value='180'<?php selected($options["chunksize"] ?? "200", "180"); ?>>180</option>
                  <option value='200'<?php selected($options["chunksize"] ?? "200", "200"); ?>>200</option>
                  <option value='220'<?php selected($options["chunksize"] ?? "200", "220"); ?>>220</option>
                  <option value='240'<?php selected($options["chunksize"] ?? "200", "240"); ?>>240</option>
                  <option value='260'<?php selected($options["chunksize"] ?? "200", "260"); ?>>260</option>
                  <option value='280'<?php selected($options["chunksize"] ?? "200", "280"); ?>>280</option>
                  <option value='300'<?php selected($options["chunksize"] ?? "200", "300"); ?>>300</option>
                  <option value='400'<?php selected($options["chunksize"] ?? "200", "400"); ?>>400</option>
                  <option value='500'<?php selected($options["chunksize"] ?? "200", "500"); ?>>500</option>
                  <option value='600'<?php selected($options["chunksize"] ?? "200", "600"); ?>>600</option>
                  <option value='700'<?php selected($options["chunksize"] ?? "200", "700"); ?>>700</option>
                  <option value='800'<?php selected($options["chunksize"] ?? "200", "800"); ?>>800</option>
                  <option value='900'<?php selected($options["chunksize"] ?? "200", "900"); ?>>900</option>
                  <option value='1000'<?php selected($options["chunksize"] ?? "200", "1000"); ?>>1000</option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHUNKSIZE_DESC')); ?></p>
            </td>
         </tr>
      </table>
      <p><input type='submit' class='button-primary' value='<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'></p>
	</div>
	<div id='tab-appearance' class='tab-content' style='display: none;'>
      <p><input type='submit' class='button-primary' value='<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'></p>
      <?php settings_fields('gptranslate_settings'); do_settings_sections('gptranslate'); ?>
      <table class='form-table'>
      	 <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_COLORS_FONTS_SETTINGS')); ?></label></th>
            <td>
            </td>
		 </tr>
         <tr>
            <th scope='row'><label for='widget_text_color'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_TEXT_COLOR')); ?></label></th>
            <td>
               <input type='color' name="gptranslate_options[widget_text_color]"
                  id='widget_text_color'
                  value='<?php echo esc_attr($options["widget_text_color"] ?? "#000000"); ?>' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_TEXT_COLOR_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='widget_background_color'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_BACKGROUND_COLOR')); ?></label></th>
            <td>
               <input type='color' name="gptranslate_options[widget_background_color]"
                  id='widget_background_color'
                  value='<?php echo esc_attr($options["widget_background_color"] ?? "#FFFFFF"); ?>' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_BACKGROUND_COLOR_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='popup_border_radius'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_BORDER_RADIUS')); ?></label></th>
            <td>
               <select name="gptranslate_options[popup_border_radius]" id='popup_border_radius'>
                  <option value='0'<?php
               		selected($options["popup_border_radius"] ?? "0", "0"); ?>>0px</option>
                  <option value='1'<?php
                     selected($options["popup_border_radius"] ?? "0", "1"); ?>>1px</option>
                  <option value='2'<?php
                     selected($options["popup_border_radius"] ?? "0", "2"); ?>>2px</option>
                  <option value='3'<?php
                     selected($options["popup_border_radius"] ?? "0", "3"); ?>>3px</option>
                  <option value='4'<?php
                     selected($options["popup_border_radius"] ?? "0", "4"); ?>>4px</option>
                  <option value='5'<?php
                     selected($options["popup_border_radius"] ?? "0", "5"); ?>>5px</option>
                  <option value='6'<?php
                     selected($options["popup_border_radius"] ?? "0", "6"); ?>>6px</option>
                  <option value='7'<?php
                     selected($options["popup_border_radius"] ?? "0", "7"); ?>>7px</option>
                  <option value='8'<?php
                     selected($options["popup_border_radius"] ?? "0", "8"); ?>>8px</option>
                  <option value='9'<?php
                     selected($options["popup_border_radius"] ?? "0", "9"); ?>>9px</option>
                  <option value='10'<?php
                     selected($options["popup_border_radius"] ?? "0", "10"); ?>>10px</option>
                  <option value='12'<?php
                     selected($options["popup_border_radius"] ?? "0", "12"); ?>>12px</option>
                  <option value='14'<?php
                     selected($options["popup_border_radius"] ?? "0", "14"); ?>>14px</option>
                  <option value='16'<?php
                     selected($options["popup_border_radius"] ?? "0", "16"); ?>>16px</option>
                  <option value='18'<?php
                     selected($options["popup_border_radius"] ?? "0", "18"); ?>>18px</option>
                  <option value='20'<?php
                     selected($options["popup_border_radius"] ?? "0", "20"); ?>>20px</option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_BORDER_RADIUS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='popup_fontsize'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_POPUP_FONTSIZE')); ?></label></th>
            <td>
               <select name="gptranslate_options[popup_fontsize]" id='popup_fontsize'>
                  <option value='8'<?php 
                  	 selected($options["popup_fontsize"] ?? "20", "8"); ?>>8px</option>
                  <option value='9'<?php
                     selected($options["popup_fontsize"] ?? "20", "9"); ?>>9px</option>
                  <option value='10'<?php
                     selected($options["popup_fontsize"] ?? "20", "10"); ?>>10px</option>
                  <option value='11'<?php
                     selected($options["popup_fontsize"] ?? "20", "11"); ?>>11px</option>
                  <option value='12'<?php
                     selected($options["popup_fontsize"] ?? "20", "12"); ?>>12px</option>
                  <option value='13'<?php
                     selected($options["popup_fontsize"] ?? "20", "13"); ?>>13px</option>
                  <option value='14'<?php
                     selected($options["popup_fontsize"] ?? "20", "14"); ?>>14px</option>
                  <option value='15'<?php
                     selected($options["popup_fontsize"] ?? "20", "15"); ?>>15px</option>
                  <option value='16'<?php
                     selected($options["popup_fontsize"] ?? "20", "16"); ?>>16px</option>
                  <option value='17'<?php
                     selected($options["popup_fontsize"] ?? "20", "17"); ?>>17px</option>
                  <option value='18'<?php
                     selected($options["popup_fontsize"] ?? "20", "18"); ?>>18px</option>
                  <option value='19'<?php
                     selected($options["popup_fontsize"] ?? "20", "19"); ?>>19px</option>
                  <option value='20'<?php
                     selected($options["popup_fontsize"] ?? "20", "20"); ?>>20px</option>
                  <option value='22'<?php
                     selected($options["popup_fontsize"] ?? "20", "22"); ?>>22px</option>
                  <option value='24'<?php
                     selected($options["popup_fontsize"] ?? "20", "24"); ?>>24px</option>
                  <option value='26'<?php
                     selected($options["popup_fontsize"] ?? "20", "26"); ?>>26px</option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_POPUP_FONTSIZE_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='popup_iconsize'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_POPUP_ICONSIZE')); ?></label></th>
            <td>
               <select name="gptranslate_options[popup_iconsize]" id='popup_iconsize'>
                  <option value='16'<?php 
                  	 selected($options["popup_iconsize"] ?? "32", "16"); ?>>16px</option>
                  <option value='18'<?php
                     selected($options["popup_iconsize"] ?? "32", "18"); ?>>18px</option>
                  <option value='20'<?php
                     selected($options["popup_iconsize"] ?? "32", "20"); ?>>20px</option>
                  <option value='22'<?php
                     selected($options["popup_iconsize"] ?? "32", "22"); ?>>22px</option>
                  <option value='24'<?php
                     selected($options["popup_iconsize"] ?? "32", "24"); ?>>24px</option>
                  <option value='26'<?php
                     selected($options["popup_iconsize"] ?? "32", "26"); ?>>26px</option>
                  <option value='28'<?php
                     selected($options["popup_iconsize"] ?? "32", "28"); ?>>28px</option>
                  <option value='30'<?php
                     selected($options["popup_iconsize"] ?? "32", "30"); ?>>30px</option>
                  <option value='32'<?php
                     selected($options["popup_iconsize"] ?? "32", "32"); ?>>32px</option>
                  <option value='34'<?php
                     selected($options["popup_iconsize"] ?? "32", "34"); ?>>34px</option>
                  <option value='36'<?php
                     selected($options["popup_iconsize"] ?? "32", "36"); ?>>36px</option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_POPUP_ICONSIZE_DESC')); ?></p>
            </td>
		</tr>
         
        <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_POSITION_STYLE_SETTINGS')); ?></label></th>
            <td>
            </td>
		</tr>
		<tr>
		    <th scope='row'><label for='float_position'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION')); ?></label></th>
		    <td>
		        <select name="gptranslate_options[float_position]" id="float_position">
		            <option value="bottom-left" <?php selected($options["float_position"] ?? "bottom-left", "bottom-left"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_BL')); ?></option>
		            <option value="bottom-right" <?php selected($options["float_position"] ?? "bottom-left", "bottom-right"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_BR')); ?></option>
		            <option value="top-left" <?php selected($options["float_position"] ?? "bottom-left", "top-left"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_TL')); ?></option>
		            <option value="top-right" <?php selected($options["float_position"] ?? "bottom-left", "top-right"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_TR')); ?></option>
		            <option value="inline" <?php selected($options["float_position"] ?? "bottom-left", "inline"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_INLINE')); ?></option>
		        </select>
		        <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_POSITION_DESC')); ?></p>
		    </td>
		</tr>
		
		<tr>
		    <th scope='row'><label for='float_switcher_open_direction'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_OPEN_DIRECTION')); ?></label></th>
		    <td>
		        <select name="gptranslate_options[float_switcher_open_direction]" id="float_switcher_open_direction">
		            <option value="left" <?php selected($options["float_switcher_open_direction"] ?? "top", "left"); ?>>Left</option>
		            <option value="right" <?php selected($options["float_switcher_open_direction"] ?? "top", "right"); ?>>Right</option>
		            <option value="top" <?php selected($options["float_switcher_open_direction"] ?? "top", "top"); ?>>Top</option>
		            <option value="bottom" <?php selected($options["float_switcher_open_direction"] ?? "top", "bottom"); ?>>Bottom</option>
		        </select>
		        <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_OPEN_DIRECTION_DESC')); ?></p>
		    </td>
		</tr>
		
		<tr>
		    <th scope='row'><label for='flag_style'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_STYLE')); ?></label></th>
		    <td>
		        <select name="gptranslate_options[flag_style]" id="flag_style">
		            <option value="2d" <?php selected($options["flag_style"] ?? "2d", "2d"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_STYLE_2D')); ?></option>
		            <option value="3d" <?php selected($options["flag_style"] ?? "2d", "3d"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_STYLE_3D')); ?></option>
		        </select>
		        <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_STYLE_DESC')); ?></p>
		    </td>
		</tr>

		<tr>
            <th scope='row'><label for='flag_loading'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_LOCATION')); ?></label></th>
            <td>
               <select name="gptranslate_options[flag_loading]" id='flag_loading'>
                  <option value='local'<?php selected($options["flag_loading"] ?? "local", "local"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_LOCAL')); ?></option>
                  <option value='cdn'<?php selected($options["flag_loading"] ?? "local", "cdn"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_CDN')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_FLAG_LOCATION_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='show_language_titles'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SHOW_LANGUAGE_TITLES')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[show_language_titles]" value='1'<?php esc_html(checked($options["show_language_titles"] ?? "1", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[show_language_titles]" value='0'<?php esc_html(checked($options["show_language_titles"] ?? "1", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_SHOW_LANGUAGE_TITLES_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='enable_dropdown'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLE_DROPDOWN')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[enable_dropdown]" value='1'<?php esc_html(checked($options["enable_dropdown"] ?? "1", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[enable_dropdown]" value='0'<?php esc_html(checked($options["enable_dropdown"] ?? "1", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_ENABLE_DROPDOWN_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='equal_widths'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EQUAL_WIDTHS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[equal_widths]" value='1'<?php esc_html(checked($options["equal_widths"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label> 
               		<label><input type='radio' name="gptranslate_options[equal_widths]" value='0'<?php esc_html(checked($options["equal_widths"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_EQUAL_WIDTHS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='reader_button_position'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_READER_BUTTON_POSITION')); ?></label></th>
            <td>
               <select name="gptranslate_options[reader_button_position]"
                  id='reader_button_position'>
                  <option value='top'<?php selected($options["reader_button_position"] ?? "top", "top"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_READER_BUTTON_POSITION_TOP')); ?></option>
                  <option value='bottom'<?php selected($options["reader_button_position"] ?? "top", "bottom"); ?>><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_READER_BUTTON_POSITION_BOTTOM')); ?></option>
               </select>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_READER_BUTTON_POSITION_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th class="settings-label-separator"><label><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CHATGPT_ADVANCED_SETTINGS')); ?></label></th>
            <td>
            </td>
		 </tr>
         <tr>
            <th scope='row'><label for='widget_max_height'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_MAX_HEIGHT')); ?></label></th>
            <td>
               <input type='number' name="gptranslate_options[widget_max_height]"
                  id='widget_max_height'
                  value='<?php echo esc_attr($options["widget_max_height"] ?? "260"); ?>' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_WIDGET_MAX_HEIGHT_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='wrapper_selector'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_WRAPPER_ELEMENT')); ?></label></th>
            <td>
               <input type='text' name="gptranslate_options[wrapper_selector]"
                  id='wrapper_selector'
                  value='<?php echo esc_attr($options["wrapper_selector"] ?? ".gptranslate_wrapper"); ?>'
                  class='regular-text' />
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CSS_WRAPPER_ELEMENT_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='draggable_widget'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DRAGGABLE_WIDGET')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[draggable_widget]" value='1'<?php esc_html(checked($options["draggable_widget"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label> 
               		<label><input type='radio' name="gptranslate_options[draggable_widget]" value='0'<?php esc_html(checked($options["draggable_widget"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DRAGGABLE_WIDGET_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='disable_control'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DISABLE_CONTROL')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[disable_control]" value='1'<?php esc_html(checked($options["disable_control"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[disable_control]" value='0'<?php esc_html(checked($options["disable_control"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DISABLE_CONTROL_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='custom_css'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CUSTOM_CSS')); ?></label></th>
            <td>
               <textarea name="gptranslate_options[custom_css]" id='custom_css' class='large-text' rows='5'><?php echo esc_textarea($options["custom_css"] ?? ""); ?></textarea>
               <p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_CUSTOM_CSS_DESC')); ?></p>
            </td>
         </tr>
         <tr>
            <th scope='row'><label for='disable_bootstrap_css'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DISABLE_BOOTSTRAP_CSS')); ?></label></th>
            <td>
            	<div class="wrapper">
               		<label><input type='radio' name="gptranslate_options[disable_bootstrap_css]" value='1'<?php esc_html(checked($options["disable_bootstrap_css"] ?? "0", "1")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_YES')); ?></span></label>
               		<label><input type='radio' name="gptranslate_options[disable_bootstrap_css]" value='0'<?php esc_html(checked($options["disable_bootstrap_css"] ?? "0", "0")); ?>> <span><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_NO')); ?></span></label>
               	</div>
               	<p class='description'><?php echo esc_html($this->loadTranslations('PLG_GPTRANSLATE_DISABLE_BOOTSTRAP_CSS_DESC')); ?></p>
            </td>
         </tr>
      </table>
      <p>
         <input type='submit' class='button-primary' value='<?php echo esc_attr($this->loadTranslations('PLG_GPTRANSLATE_SAVE_SETTINGS')); ?>'>
      </p>
      </div>
   </form>
</div>