<?php
namespace FEACF\Frontend;

class LegacyForm {
    public static function enqueue_legacy_assets() {
        // Enqueue ACF's frontend assets if needed
        wp_enqueue_script('feacf-frontend-legacy', FEACF_PLUGIN_URL . '/assets-legacy/script.js', [], '1.0.0', true);
        wp_enqueue_style('feacf-frontend-legacy', FEACF_PLUGIN_URL . '/assets-legacy/style.css', [], '1.0.0');
    }

    public static function add_acf_head(){
        if( ! function_exists( 'acf_form' ) ) return;
        acf_form_head();
    }

    public static function add_link_to_admin_bar(){
        // return if not single 
        if( ! is_singular() ) return;
        if( ! function_exists( 'acf_form' ) ) return;
        if( !current_user_can('edit_posts') ) return;
        global $wp_admin_bar;
        $wp_admin_bar->add_node([
            'id' => 'wpvfe-acf',
            'title' => __('Edit ACF', 'frontend-editor-acf'),
            'href' => '#',
            'meta' => [
                'class' => 'wpvfe-acf',
                'target' => '_blank'
            ]
        ]);
    }
    public static function render() {
        
        if (!function_exists('acf_form')) {
            echo '<div style="color:red;">ACF plugin is required for legacy form.</div>';
            return;
        }

        $args = apply_filters('feacf_legacy_form_args', [
            'post_id' => get_queried_object_id(),
            'field_groups' => false,
            'form' => true,
            'return' => add_query_arg('updated', 'true', get_permalink()),
            'submit_value' => __('Update', 'frontend-editor-acf'),
        ]);

        ?>
        <div id="fe-acf-panel" class="hidden">
            <header class="fe-acf-panel-header">
                <span class="header-title"><?php _e('Edit Post', 'frontend-editor-acf'); ?></span>
                <button aria-label="<?php _e('Close this dialog', 'frontend-editor-acf'); ?>" type="button">
                  <i class="el-icon el-drawer__close">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024">
                      <path fill="currentColor" d="M764.288 214.592 512 466.88 259.712 214.592a31.936 31.936 0 0 0-45.12 45.12L466.752 512 214.528 764.224a31.936 31.936 0 1 0 45.12 45.184L512 557.184l252.288 252.288a31.936 31.936 0 0 0 45.12-45.12L557.12 512.064l252.288-252.352a31.936 31.936 0 1 0-45.12-45.184z"></path>
                    </svg>
                  </i>
                </button>
            </header>
            <div class="fe-acf-panel-body">
                <form method="post">
                    <?php 
                        acf_form( array_merge( $args, [ 'form' => false ] ) )
                    ?>
                    <div class="acf-form-submit">
                        <input type="submit" class="button" id="submitpost" value="<?php echo esc_attr($args['submit_value']); ?>" />
                    </div> 
                </form>
            </div>

            <div class="fe-acf-panel-footer">
                <button id="fe-acf-cancel" aria-disabled="false" type="button" class="el-button fe-cancel">
                    <span class=""><?php _e('Cancel', 'frontend-editor-acf'); ?></span>
                </button>
                <button id="fe-acf-update" aria-disabled="false" type="submit" class="el-button el-button--primary fe-acf-update">
                    <span class=""><?php _e('Update', 'frontend-editor-acf'); ?></span>
                </button>
            </div>
            
        </div>
        <?php
    }
}