<?php
namespace FEACF\Core;

if(!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Plugin {
    private static $instance = null;

    private static $use_legacy = false;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('after_setup_theme', [ $this, 'maybe_boot' ], 20);
    }

    public function maybe_boot() {
        // Check for legacy mode after theme setup so theme filters are available
        self::$use_legacy = apply_filters('feacf_use_legacy_form', false);
        // add_filter('feacf_use_legacy_form', '__return_true'); // Enable legacy mode
        if (self::$use_legacy) {
            // Only render legacy form, do not enqueue Vue assets or buttons
            add_action('wp_footer', function() {
                // Autoload or require the class if not using Composer
                if (!class_exists('\\FEACF\\Frontend\\LegacyForm')) {
                    require_once dirname(__DIR__, 1) . '/Frontend/LegacyForm.php';
                }
                \FEACF\Frontend\LegacyForm::render();
            });
            add_action('get_header', [\FEACF\Frontend\LegacyForm::class, 'add_acf_head']);
            add_action('admin_bar_menu', [\FEACF\Frontend\LegacyForm::class, 'add_link_to_admin_bar'], 999);
            add_action('wp_enqueue_scripts', [\FEACF\Frontend\LegacyForm::class, 'enqueue_legacy_assets']);
            return;
        }

        // Vue-based workflow (default)
        add_action('wp_enqueue_scripts', [\FEACF\Core\Assets::class, 'enqueue']);
        add_action('wp_footer', [\FEACF\Frontend\Frontend::class, 'render']);

        // Register AJAX actions for frontend ACF editing
        add_action('wp_ajax_feacf_get_fields', [\FEACF\Ajax\GetACFFields::class, 'ajax_handle']);
        add_action('wp_ajax_feacf_save_fields', [\FEACF\Ajax\SaveACFData::class, 'ajax_handle']);
    }
    
}
