<?php
namespace FEACF\Core;

class Assets {
    /**
     * Get supported field types for frontend editing. In future, this can be extended to pull from admin settings or user meta.
     *
     * @return array
     */

    public static function enqueue() {
        if (\FEACF\Utils\Helper::can_edit_frontend_acf()) {
            wp_enqueue_script('feacf-frontend', FEACF_ASSETS_URL . "feacf-frontend.js", [], FEACF_VERSION, true);
            wp_enqueue_style('feacf-frontend', FEACF_ASSETS_URL . "feacf-frontend.css", [], FEACF_VERSION);

            wp_enqueue_media();
            wp_enqueue_editor();

            // Enqueue WP editor scripts/styles for frontend TinyMCE (WYSIWYG) support
            wp_enqueue_script('editor');
            wp_enqueue_script('media-upload');
            wp_enqueue_script('thickbox');
            wp_enqueue_style('thickbox');
            wp_localize_script('feacf-frontend', 'feacfData', [
                'postId' => get_the_ID(),
                'nonce' => wp_create_nonce('feacf_nonce'),
                'ajaxUrl' => add_query_arg('action', 'feacf_get_acf_fields', admin_url('admin-ajax.php')),
                'rest_url' => esc_url_raw( rest_url() ),
                'rest_nonce' => wp_create_nonce( 'wp_rest' ),
                'supportedFields' => \FEACF\Utils\Helper::get_supported_fields(),
            ]);
        }
    }
}
