<?php
namespace FEACF\Ajax;

class SaveACFData { 
    
    // AJAX handler
    public static function ajax_handle() {
    // Nonce check (will exit on failure)
        check_ajax_referer('feacf_nonce', '_ajax_nonce');

        $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;
        $fields = isset($_POST['fields']) ? json_decode(wp_unslash($_POST['fields']), true) : null;

        if (!$post_id || !get_post($post_id)) {
            wp_send_json_error(['message' => 'Missing or invalid post_id'], 400);
        }

        if (empty($fields)) {
            wp_send_json_error(['message' => 'Missing or invalid fields'], 400);
        }

        if (!current_user_can('edit_post', $post_id)) {
            wp_send_json_error(['message' => 'User cannot edit this post'], 403);
        }

        foreach ($fields as $key => $value) {
            $key = sanitize_text_field($key);
            $field_object = get_field_object($key, $post_id);
            if (!$field_object) {
                continue;
            }

            // Improved image/file normalization
            if (in_array($field_object['type'], ['image', 'file'], true)) {
                // Normalize to an attachment ID
                if (is_array($value)) {
                    if (isset($value['id'])) {
                        $value = absint($value['id']);
                    } elseif (isset($value['url'])) {
                        $id = attachment_url_to_postid($value['url']);
                        if ($id) { $value = $id; } else { continue; }
                    }
                } elseif (is_object($value)) {
                    if (isset($value->id)) {
                        $value = absint($value->id);
                    } elseif (isset($value->url)) {
                        $id = attachment_url_to_postid($value->url);
                        if ($id) { $value = $id; } else { continue; }
                    }
                } elseif (is_string($value) && !is_numeric($value)) {
                    $id = attachment_url_to_postid($value);
                    if ($id) { $value = $id; } else { continue; }
                }
                if (is_numeric($value)) {
                    $value = absint($value);
                } else {
                    // Unsupported format for media field; skip
                    continue;
                }
            }

            // Sanitize value
            if ($field_object['type'] === 'wysiwyg') {
                $sanitized = isset($value) ? wp_kses_post($value) : '';
            } else {
                $sanitized = \FEACF\Utils\Helper::sanitize_acf_input($value);
            }

            update_field($key, $sanitized, $post_id);
        }

        wp_send_json_success(['message' => 'Fields updated']);
    }
}
