<?php
namespace FEACF\Ajax;

class GetACFFields {
    // AJAX handler
    public static function ajax_handle() {
        if(!wp_verify_nonce($_POST['_ajax_nonce'] ?? '', 'feacf_nonce')) {
            wp_send_json_error(['message' => 'Invalid nonce'], 403);
            return;
        }

        $post_id = isset($_POST['post_id']) ? absint(wp_unslash($_POST['post_id'])) : 0;
        if (!$post_id) {
            wp_send_json_error(['message' => 'Missing post_id'], 400);
            return;
        }
        if (!get_post($post_id)) {
            wp_send_json_error(['message' => 'Invalid post_id'], 400);
            return;
        }
        
        if (!current_user_can('edit_post', $post_id)) {
            wp_send_json_error(['message' => 'User cannot edit this post'], 403);
            return;
        }

        if (!function_exists('acf_get_field_groups') || !function_exists('acf_get_fields')) {
            wp_send_json_error(['message' => 'ACF not loaded'], 500);
        }
        $groups = acf_get_field_groups(['post_id' => $post_id]);
        $all_fields = [];
        $supported_types = \FEACF\Utils\Helper::get_supported_fields();
        foreach ($groups as $group) {
            $fields = acf_get_fields($group['ID']);
            if (is_array($fields)) {
                foreach ($fields as $field) {
                    if (!in_array($field['type'], $supported_types, true)) continue;
                    //$value = get_field($field['key'], $post_id);
                    // Send the full field object, plus value and group
                    $field_obj = $field;
                    switch ($field['type']) {
                        case 'checkbox':
                        case 'select':
                        case 'time_picker':       
                            $field_obj['value'] = get_field($field['key'], $post_id, false);
                            break;
                        case 'date_picker':
                            $value = get_field($field['key'], $post_id);
                            $field_obj['value'] = \FEACF\Utils\Helper::format_date_picker($value);
                            break;
                        case 'oembed':
                            $field_obj['value'] = \FEACF\Utils\Helper::format_oembed($field['name'], $post_id);
                            break;
                        case 'date_time_picker':
                            $value = get_field($field['key'], $post_id,false);
                            if($value == null && $field['default_to_current_date'] == true ){ 
                                $field_obj['value'] = current_time('Y-m-d H:i:s');
                            } else {
                                $field_obj['value'] = get_field($field['key'], $post_id, false);;
                            }
                            break;
                        default:
                            $field_obj['value'] = get_field($field['key'], $post_id);
                    }
                    $field_obj['group'] = $group['ID'];
                    $all_fields[] = $field_obj;
                }
            }
        }
        if (empty($all_fields)) {
            wp_send_json_error(['message' => 'No ACF fields found'], 404);
        }
        wp_send_json_success(['fields' => $all_fields]);
    }
}
