<?php
/**
 * Plugin Name: Frontend Editor ACF
 * Plugin URI: https://wpvibes.com
 * Description: Edit ACF fields from the frontend via a floating Vue sidebar.
 * Version: 1.0.1
 * Author: WPVibes
 * License: GPLv2
 * Text Domain: frontend-editor-acf
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
if (!defined('FEACF_VERSION')) {
    define('FEACF_VERSION', '1.0.1');
}

if (!defined('FEACF_PLUGIN_DIR')) {
    define('FEACF_PLUGIN_DIR', plugin_dir_path(__FILE__));
}
if (!defined('FEACF_PLUGIN_URL')) {
    define('FEACF_PLUGIN_URL', plugin_dir_url(__FILE__));
}
if (!defined('FEACF_ASSETS_URL')) {
    define('FEACF_ASSETS_URL', FEACF_PLUGIN_URL . 'assets/');
}

// Composer autoload
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
}

// Show admin notice and prevent plugin from running if ACF is not active
if (!class_exists('ACF')) {
    add_action('admin_notices', function() {
        if (current_user_can('activate_plugins')) {
            echo '<div class="notice notice-error"><p>' . esc_html__('Frontend Editor ACF requires the Advanced Custom Fields (ACF) plugin to be installed and activated.', 'frontend-editor-acf') . '</p></div>';
        }
    });
    return;
}

// Boot plugin
FEACF\Core\Plugin::get_instance();
