<?php
namespace Frontend_Admin\Field_Types;

if ( ! class_exists( 'Frontend_Admin\Field_Types\plans' ) ) :


	class plans extends Field_Base {


		/*
		*  __construct
		*
		*  This function will setup the field type data
		*
		*  @type    function
		*  @date    5/03/2014
		*  @since   5.0.0
		*
		*  @param   n/a
		*  @return  n/a
		*/

		function initialize() {

			// vars
			$this->name     = 'fea_plans';
			$this->label    = __( 'Plans', 'frontend-admin' );
			$this->category = 'relational';
			$this->public = false;
			$this->defaults = array(
				'allow_null'    => 0,
				'multiple'      => 0,
				'return_format' => 'object',
				'ui'            => 1,
				'add_plan'      => 0,
				'edit_plans'    => 0,
			);


		}

		/*
		*  render_field()
		*
		*  Create the HTML interface for your field
		*
		*  @param   $field - an array holding all the field's data
		*
		*  @type    action
		*  @since   3.6
		*  @date    23/01/13
		*/

		function render_field( $field ) {

			// convert
			$field['value'] = acf_get_array( $field['value'] );
			$plans = fea_instance()->plans_handler->get_plans();

			$choices = [];

			?>
			<div class="fea-plans">

			<?php
			foreach( $plans as $plan ){
				$this->render_single_plan( $plan, $field );
			}
			$this->render_single_plan( 'clone', $field );
			?>
			</div>

			<?php
			if( $field['add_plan'] ?? false ){
				?>
				<div>
					<a href="#" title="<?php esc_html_e( 'Add Plan', 'frontend-admin' ); ?>" class="acf-icon -plus small add-plan"></a>		
				</div>
				<?php
			}
		}

		function render_single_plan( $plan, $field ){
			if( 'clone' == $plan ){
				$choice = [
					'label' => '',
					'value' => '',
					'name' => $field['name'],
					'disabled' => 'disabled'
				];
			}else{
				$choice = [
					'label' => $plan['title'] . ' - ' . $plan['pricing'] . ' ' . $plan['currency'],
					'value' => $plan['id'],
					'name' => $field['name']
				];
				if( in_array( intval( $plan['id'] ), $field['value'], true ) ){
					$choice['checked'] = true;
				}
			}
			
			?>
			<div class="fea-single-plan <?php if( 'clone' == $plan ) echo 'acf-hidden clone'; ?>" data-plan="<?php esc_attr_e( $choice['value'] ); ?>">
			<?php
			$label = '';
			if ( isset( $choice['label'] ) ) {
				$label = $choice['label'];
				unset( $choice['label'] );
			}
		
			// Render.
			$checked = isset( $choice['checked'] );
			echo '<label' . ( $checked ? ' class="selected"' : '' ) . '><input type="radio" ' . acf_esc_attr( $choice ) . '/> <span class="fea-plan-title">' . acf_esc_html( $label ) . '</span></label>';
			if( $field['edit_plans'] ?? false )	$this->render_plan_actions( $plan['id'] ?? '' );
			?>
			</div>
			<?php
		}

		function render_plan_actions( $plan ){
			?>
				<a href="#" title="<?php esc_html_e( 'Edit Plan', 'frontend-admin' ); ?>" class="acf-icon -pencil small edit-plan"></a>
				<a href="#" title="<?php esc_html_e( 'Delete Plan', 'frontend-admin' ); ?>" class="acf-icon -minus small delete-plan"></a>
			<?php
		}

	}

endif; // class_exists check


