<?php
/**
 * Plugin Name: EDU - Anúncio (Form Frontend ACF)
 * Description: Formulário frontend para cadastrar CPT anuncio com taxonomias e campos ACF.
 */

if (!defined('ABSPATH')) exit;

/**
 * 1) Garante que o ACF Form Head rode quando a página tiver o shortcode.
 *    (necessário pro acf_form funcionar no frontend)
 */
add_action('template_redirect', function () {
	if (!function_exists('acf_form_head')) return;
	if (!is_singular() && !is_page()) return;

	global $post;
	if (!$post) return;

	if (has_shortcode($post->post_content, 'edu_anuncio_form') || has_shortcode($post->post_content, 'edu_admin_anuncio')) {
		acf_form_head();
	}
}, 0);


/**
 * 2) Campo ACF (local) para as Taxonomias do Anúncio
 *    Isso coloca no formulário: Polo, Cidade, Destino, Categoria (única), Serviços (múltiplos).
 */
add_action('acf/init', function () {
	if (!function_exists('acf_add_local_field_group')) return;

	acf_add_local_field_group([
		'key' => 'group_edu_anuncio_tax',
		'title' => 'Anúncio — Taxonomias',
		'fields' => [
			[
				'key' => 'field_edu_anuncio_categoria',
				'label' => 'Categoria do anúncio (única)',
				'name' => 'edu_anuncio_categoria',
				'type' => 'taxonomy',
				'taxonomy' => 'categoria_anuncio',
				'field_type' => 'radio',
				'add_term' => 0,
				'save_terms' => 1,
				'load_terms' => 1,
				'return_format' => 'id',
				'allow_null' => 0,
				'multiple' => 0,
				'required' => 1,
				'wrapper' => ['width' => '100'],
			],
			[
				'key' => 'field_edu_anuncio_polo',
				'label' => 'Polo Turístico',
				'name' => 'edu_anuncio_polo',
				'type' => 'taxonomy',
				'taxonomy' => 'polo_turistico',
				'field_type' => 'select',
				'add_term' => 0,
				'save_terms' => 1,
				'load_terms' => 1,
				'return_format' => 'id',
				'allow_null' => 0,
				'multiple' => 0,
				'required' => 1,
				'ui' => 1,
				'ajax' => 0,
				'wrapper' => ['width' => '33'],
			],
			[
				'key' => 'field_edu_anuncio_cidade',
				'label' => 'Cidade',
				'name' => 'edu_anuncio_cidade',
				'type' => 'taxonomy',
				'taxonomy' => 'cidade',
				'field_type' => 'select',
				'add_term' => 0,
				'save_terms' => 1,
				'load_terms' => 1,
				'return_format' => 'id',
				'allow_null' => 0,
				'multiple' => 0,
				'required' => 1,
				'ui' => 1,
				'ajax' => 1,
				'wrapper' => ['width' => '33'],
			],
			[
				'key' => 'field_edu_anuncio_destino',
				'label' => 'Destino / Local (opcional)',
				'name' => 'edu_anuncio_destino',
				'type' => 'taxonomy',
				'taxonomy' => 'destino_turistico',
				'field_type' => 'select',
				'add_term' => 0,
				'save_terms' => 1,
				'load_terms' => 1,
				'return_format' => 'id',
				'allow_null' => 1,
				'multiple' => 0,
				'required' => 0,
				'ui' => 1,
				'ajax' => 1,
				'wrapper' => ['width' => '33'],
			],
			[
				'key' => 'field_edu_anuncio_servicos',
				'label' => 'Serviços (marque tudo que se aplica)',
				'name' => 'edu_anuncio_servicos',
				'type' => 'taxonomy',
				'taxonomy' => 'servicos',
				'field_type' => 'checkbox',
				'add_term' => 0,
				'save_terms' => 1,
				'load_terms' => 1,
				'return_format' => 'id',
				'allow_null' => 0,
				'multiple' => 1,
				'required' => 1,
				'wrapper' => ['width' => '100'],
			],
		],
		'location' => [
			[
				[
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'anuncio',
				],
			],
		],
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => [],
	]);
});


/**
 * 3) Shortcode do Formulário de Cadastro do Anúncio
 * Uso: [edu_anuncio_form]
 */
add_shortcode('edu_anuncio_form', function ($atts) {
	if (!function_exists('acf_form')) {
		return '<p><strong>ACF Pro</strong> não está ativo.</p>';
	}

	if (!is_user_logged_in()) {
		return '<p>Você precisa estar logado para cadastrar anúncios.</p>';
	}

	$atts = shortcode_atts([
		'status' => 'publish', // agente publica direto
	], $atts);

	ob_start();

	echo '<div class="edu-anuncio-form">';
	echo '<h2>Cadastrar anúncio</h2>';
	echo '<p>Preencha os dados abaixo. A <strong>categoria é única</strong>. Serviços podem ser múltiplos.</p>';

	acf_form([
		'post_id' => 'new_post',
		'new_post' => [
			'post_type'   => 'anuncio',
			'post_status' => sanitize_text_field($atts['status']),
		],
		'post_title'   => true,
		'post_content' => true,

		// Puxa TODOS os field groups vinculados ao post_type anuncio
		// (inclui os seus grupos existentes + o grupo de taxonomias que criamos acima)
		'field_groups' => [],

		'submit_value' => 'Publicar anúncio',
		'updated_message' => 'Anúncio criado com sucesso.',
	]);

	echo '</div>';

	return ob_get_clean();
});

/**
 * 4) Shortcode ADMIN do Formulário de Cadastro do Anúncio
 * Uso: [edu_admin_anuncio]
 * - Exige login
 * - Restringe para administradores (manage_options)
 * - Publica direto (por padrão), mas aceita status="pending"
 */
add_shortcode('edu_admin_anuncio', function ($atts) {
	if (!function_exists('acf_form')) {
		return '<p><strong>ACF Pro</strong> não está ativo.</p>';
	}

	if (!is_user_logged_in()) {
		$redirect = urlencode((is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
		return '<p>Login obrigatório. <a href="/wp-login.php?redirect_to=' . $redirect . '"><strong>Clique para entrar</strong></a>.</p>';
	}

	if (!current_user_can('manage_options')) {
		return '<p>Somente administradores podem cadastrar anúncio por este formulário.</p>';
	}

	$atts = shortcode_atts([
		'status' => 'publish',
	], $atts);

	ob_start();

	echo '<div class="edu-anuncio-form edu-anuncio-form-admin">';
	echo '<h2>Cadastrar anúncio (Admin)</h2>';
	echo '<p>Preencha os dados abaixo. A <strong>categoria é única</strong>. Serviços podem ser múltiplos.</p>';

	acf_form([
		'post_id' => 'new_post',
		'new_post' => [
			'post_type'   => 'anuncio',
			'post_status' => sanitize_text_field($atts['status']),
		],
		'post_title'   => true,
		'post_content' => true,
		'field_groups' => [],
		'submit_value' => 'Publicar anúncio (Admin)',
		'updated_message' => 'Anúncio criado com sucesso.',
	]);

	echo '</div>';

	return ob_get_clean();
});

