<?php
/**
 * CPT: Anúncio
 */

add_action('init', function () {

    $labels = [
        'name'               => 'Anúncios',
        'singular_name'      => 'Anúncio',
        'menu_name'          => 'Anúncios',
        'name_admin_bar'     => 'Anúncio',
        'add_new'            => 'Adicionar novo',
        'add_new_item'       => 'Adicionar novo anúncio',
        'new_item'           => 'Novo anúncio',
        'edit_item'          => 'Editar anúncio',
        'view_item'          => 'Ver anúncio',
        'all_items'          => 'Todos os anúncios',
        'search_items'       => 'Buscar anúncios',
        'not_found'          => 'Nenhum anúncio encontrado',
        'not_found_in_trash' => 'Nenhum anúncio na lixeira',
    ];

    register_post_type('anuncio', [
        'labels'             => $labels,
        'public'             => true,
        'has_archive'        => true,
        'rewrite'            => ['slug' => 'anuncio'],
        'menu_position'      => 5,
        'menu_icon'          => 'dashicons-megaphone',
        'supports'           => [
            'title',
            'editor',
            'thumbnail',
            'author',
            'revisions',
        ],
        'taxonomies'         => [
            'categoria_anuncio',
            'cidade',
            'servicos',
            'destino_turistico',
        ],
        'show_in_rest'       => true,
        'capability_type'    => 'post',
        'map_meta_cap'       => true,
    ]);

});
