<?php
/**
 * MU Plugin: ACF Fields for CPT "anuncio"
 * Path: wp-content/mu-plugins/acf-anuncio-fields.php
 */

if ( ! defined('ABSPATH') ) { exit; }

/**
 * Register local ACF field groups.
 * - Requires ACF (free or pro).
 * - Safe for MU-plugins.
 */
add_action('acf/init', function () {

    if ( ! function_exists('acf_add_local_field_group') ) {
        return;
    }

    // Helper: common group settings
    $common = [
        'location' => [
            [
                [
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'anuncio',
                ],
            ],
        ],
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'seamless',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'active' => true,
        'show_in_rest' => 1,
    ];

    /**
     * GROUP 2 — Contato, CTA & Fiscal
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_contato_cta_fiscal',
        'title' => 'Contato, CTA e Dados Fiscais',
        'fields' => [
            [
                'key' => 'field_anuncio_whatsapp',
                'label' => 'WhatsApp',
                'name' => 'whatsapp',
                'type' => 'text',
                'required' => 1,
                'wrapper' => ['width' => '50'],
                'instructions' => 'Número com DDD. Ex: 91 9XXXX-XXXX',
            ],
            [
                'key' => 'field_anuncio_telefone_secundario',
                'label' => 'Telefone secundário',
                'name' => 'telefone_secundario',
                'type' => 'text',
                'required' => 0,
                'wrapper' => ['width' => '50'],
            ],
            [
                'key' => 'field_anuncio_email_contato',
                'label' => 'E-mail',
                'name' => 'email_contato',
                'type' => 'email',
                'required' => 0,
                'wrapper' => ['width' => '50'],
            ],
            [
                'key' => 'field_anuncio_site_instagram',
                'label' => 'Site ou Instagram',
                'name' => 'site_instagram',
                'type' => 'url',
                'required' => 0,
                'wrapper' => ['width' => '50'],
            ],
            [
                'key' => 'field_anuncio_cta_texto',
                'label' => 'Texto do botão CTA',
                'name' => 'cta_texto',
                'type' => 'text',
                'required' => 0,
                'default_value' => 'Falar no WhatsApp',
                'wrapper' => ['width' => '50'],
            ],
            [
                'key' => 'field_anuncio_cta_link',
                'label' => 'Link do CTA',
                'name' => 'cta_link',
                'type' => 'url',
                'required' => 0,
                'wrapper' => ['width' => '50'],
                'instructions' => 'Pode ser link wa.me, site, Instagram, etc.',
            ],
            [
                'key' => 'field_anuncio_cpf_cnpj',
                'label' => 'CPF ou CNPJ',
                'name' => 'cpf_cnpj',
                'type' => 'text',
                'required' => 1,
                'instructions' => 'Obrigatório para faturamento / emissão de nota (campo interno).',
                'wrapper' => ['width' => '50'],
            ],
        ],
    ]));

    /**
     * GROUP 3 — Localização & Mapa (Mapbox via lat/long)
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_localizacao_mapa',
        'title' => 'Localização e Mapa',
        'fields' => [
            [
                'key' => 'field_anuncio_endereco',
                'label' => 'Endereço',
                'name' => 'endereco',
                'type' => 'text',
                'required' => 1,
                'wrapper' => ['width' => '70'],
            ],
            [
                'key' => 'field_anuncio_bairro',
                'label' => 'Bairro',
                'name' => 'bairro',
                'type' => 'text',
                'required' => 0,
                'wrapper' => ['width' => '30'],
            ],
            [
                'key' => 'field_anuncio_cep',
                'label' => 'CEP',
                'name' => 'cep',
                'type' => 'text',
                'required' => 0,
                'wrapper' => ['width' => '30'],
            ],
            [
                'key' => 'field_anuncio_latitude',
                'label' => 'Latitude',
                'name' => 'latitude',
                'type' => 'number',
                'required' => 1,
                'wrapper' => ['width' => '35'],
                'step' => '0.0000001',
                'instructions' => 'Obrigatório. Usado no Mapbox.',
            ],
            [
                'key' => 'field_anuncio_longitude',
                'label' => 'Longitude',
                'name' => 'longitude',
                'type' => 'number',
                'required' => 1,
                'wrapper' => ['width' => '35'],
                'step' => '0.0000001',
                'instructions' => 'Obrigatório. Usado no Mapbox.',
            ],
            [
                'key' => 'field_anuncio_google_maps_url',
                'label' => 'Link (opcional)',
                'name' => 'mapa_link',
                'type' => 'url',
                'required' => 0,
                'wrapper' => ['width' => '100'],
                'instructions' => 'Opcional (ex.: link de referência). O mapa principal será Mapbox.',
            ],
        ],
    ]));

    /**
     * GROUP 5 — Descrição & Conteúdo
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_descricao_conteudo',
        'title' => 'Descrição do Anúncio',
        'fields' => [
            [
                'key' => 'field_anuncio_descricao_curta',
                'label' => 'Descrição curta',
                'name' => 'descricao_curta',
                'type' => 'textarea',
                'required' => 0,
                'rows' => 3,
                'instructions' => 'Usada em cards/listagens.',
            ],
            [
                'key' => 'field_anuncio_descricao_completa',
                'label' => 'Descrição completa',
                'name' => 'descricao_completa',
                'type' => 'wysiwyg',
                'required' => 0,
                'media_upload' => 1,
            ],
            [
                'key' => 'field_anuncio_faixa_preco',
                'label' => 'Faixa de preço',
                'name' => 'faixa_preco',
                'type' => 'text',
                'required' => 0,
                'instructions' => 'Ex.: $$, $$$ ou "Sob consulta".',
                'wrapper' => ['width' => '50'],
            ],
            [
                'key' => 'field_anuncio_observacoes',
                'label' => 'Observações',
                'name' => 'observacoes',
                'type' => 'textarea',
                'required' => 0,
                'rows' => 3,
                'wrapper' => ['width' => '50'],
            ],
        ],
    ]));

    /**
     * GROUP 6 — Horários (Repeater)
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_horarios',
        'title' => 'Horários de Funcionamento',
        'fields' => [
            [
                'key' => 'field_anuncio_horarios',
                'label' => 'Horários',
                'name' => 'horarios',
                'type' => 'repeater',
                'required' => 0,
                'min' => 0,
                'layout' => 'row',
                'button_label' => 'Adicionar horário',
                'sub_fields' => [
                    [
                        'key' => 'field_anuncio_horario_dia',
                        'label' => 'Dia da semana',
                        'name' => 'dia',
                        'type' => 'select',
                        'required' => 1,
                        'choices' => [
                            'segunda' => 'Segunda',
                            'terca' => 'Terça',
                            'quarta' => 'Quarta',
                            'quinta' => 'Quinta',
                            'sexta' => 'Sexta',
                            'sabado' => 'Sábado',
                            'domingo' => 'Domingo',
                        ],
                        'wrapper' => ['width' => '25'],
                    ],
                    [
                        'key' => 'field_anuncio_horario_abertura',
                        'label' => 'Abertura',
                        'name' => 'abertura',
                        'type' => 'time_picker',
                        'required' => 0,
                        'display_format' => 'H:i',
                        'return_format' => 'H:i',
                        'wrapper' => ['width' => '20'],
                    ],
                    [
                        'key' => 'field_anuncio_horario_fechamento',
                        'label' => 'Fechamento',
                        'name' => 'fechamento',
                        'type' => 'time_picker',
                        'required' => 0,
                        'display_format' => 'H:i',
                        'return_format' => 'H:i',
                        'wrapper' => ['width' => '20'],
                    ],
                    [
                        'key' => 'field_anuncio_horario_obs',
                        'label' => 'Observação',
                        'name' => 'observacao',
                        'type' => 'text',
                        'required' => 0,
                        'wrapper' => ['width' => '35'],
                    ],
                ],
            ],
        ],
    ]));

    /**
     * GROUP 7 — Mídia (capa alternativa obrigatória)
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_midia',
        'title' => 'Mídia do Anúncio',
        'fields' => [
            [
                'key' => 'field_anuncio_capa_alternativa',
                'label' => 'Imagem de capa alternativa',
                'name' => 'capa_alternativa',
                'type' => 'image',
                'required' => 1,
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'instructions' => 'Obrigatória. Usada em cards/destaques quando necessário.',
            ],
            [
                'key' => 'field_anuncio_galeria',
                'label' => 'Galeria de imagens',
                'name' => 'galeria',
                'type' => 'gallery',
                'required' => 0,
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
            ],
            [
                'key' => 'field_anuncio_video_url',
                'label' => 'Vídeo (URL)',
                'name' => 'video_url',
                'type' => 'url',
                'required' => 0,
                'instructions' => 'YouTube/Vimeo/URL pública.',
                'wrapper' => ['width' => '70'],
            ],
            [
                'key' => 'field_anuncio_logo',
                'label' => 'Logo (opcional)',
                'name' => 'logo',
                'type' => 'image',
                'required' => 0,
                'return_format' => 'url',
                'preview_size' => 'thumbnail',
                'library' => 'all',
                'wrapper' => ['width' => '30'],
            ],
        ],
    ]));

    /**
     * GROUP 8 — Controle interno (datas/destaque/prioridade/verificado)
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_controle_interno',
        'title' => 'Controle Interno do Anúncio',
        'fields' => [
            [
                'key' => 'field_anuncio_data_inicio',
                'label' => 'Data início de exibição',
                'name' => 'data_inicio',
                'type' => 'date_picker',
                'required' => 0,
                'display_format' => 'd/m/Y',
                'return_format' => 'Y-m-d',
                'wrapper' => ['width' => '25'],
            ],
            [
                'key' => 'field_anuncio_data_fim',
                'label' => 'Data fim de exibição',
                'name' => 'data_fim',
                'type' => 'date_picker',
                'required' => 0,
                'display_format' => 'd/m/Y',
                'return_format' => 'Y-m-d',
                'wrapper' => ['width' => '25'],
            ],
            [
                'key' => 'field_anuncio_destaque',
                'label' => 'Destaque',
                'name' => 'destaque',
                'type' => 'true_false',
                'required' => 0,
                'ui' => 1,
                'wrapper' => ['width' => '20'],
            ],
            [
                'key' => 'field_anuncio_prioridade',
                'label' => 'Prioridade',
                'name' => 'prioridade',
                'type' => 'number',
                'required' => 0,
                'default_value' => 0,
                'wrapper' => ['width' => '15'],
                'instructions' => 'Maior = aparece antes (quando aplicável).',
            ],
            [
                'key' => 'field_anuncio_verificado',
                'label' => 'Verificado',
                'name' => 'verificado',
                'type' => 'true_false',
                'required' => 0,
                'ui' => 1,
                'wrapper' => ['width' => '15'],
            ],
            [
                'key' => 'field_anuncio_obs_internas',
                'label' => 'Observações internas',
                'name' => 'observacoes_internas',
                'type' => 'textarea',
                'required' => 0,
                'rows' => 3,
            ],
        ],
    ]));

    /**
     * GROUP 9 — Metadados técnicos (obrigatório p/ governança/faturamento)
     */
    acf_add_local_field_group(array_merge($common, [
        'key' => 'group_anuncio_metadados_tecnicos',
        'title' => 'Metadados Técnicos',
        'fields' => [
            [
                'key' => 'field_anuncio_id_agente',
                'label' => 'ID do agente responsável',
                'name' => 'id_agente',
                'type' => 'number',
                'required' => 1,
                'wrapper' => ['width' => '50'],
                'instructions' => 'Obrigatório. Usado para relatórios/contabilidade.',
            ],
            [
                'key' => 'field_anuncio_origem',
                'label' => 'Origem do anúncio',
                'name' => 'origem_anuncio',
                'type' => 'select',
                'required' => 1,
                'wrapper' => ['width' => '50'],
                'choices' => [
                    'agente' => 'Agente',
                    'usuario_final' => 'Usuário final',
                    'admin' => 'Admin (interno)',
                ],
                'default_value' => 'agente',
                'ui' => 1,
            ],
            [
                'key' => 'field_anuncio_codigo_interno',
                'label' => 'Código interno do anunciante (opcional)',
                'name' => 'codigo_interno',
                'type' => 'text',
                'required' => 0,
            ],
        ],
    ]));

});


/**
 * Runtime helpers (front-end forms)
 * - Detect admin-only announce page (shortcode [edu_admin_anuncio])
 * - Set default origem_anuncio = admin for admin form (but keep other options available)
 * - Allow admin to create Destinos Turísticos terms directly in the form
 */
add_action('wp', function () {
    // Flag only on the front-end page that contains the admin form shortcode
    if (is_admin()) { return; }
    global $post;
    if ($post && isset($post->post_content) && has_shortcode($post->post_content, 'edu_admin_anuncio')) {
        if (!defined('EDU_IS_ADMIN_ANUNCIO_FORM')) {
            define('EDU_IS_ADMIN_ANUNCIO_FORM', true);
        }
    }
});

// Admin form: default origem_anuncio to "admin" when empty (new post), without removing other choices
add_filter('acf/load_value/name=origem_anuncio', function ($value, $post_id, $field) {
    if (
        current_user_can('manage_options')
        && (defined('EDU_IS_ADMIN_ANUNCIO_FORM') && EDU_IS_ADMIN_ANUNCIO_FORM)
        && empty($value)
    ) {
        return 'admin';
    }
    return $value;
}, 10, 3);

// Admin form: allow creating Destino Turístico terms from the taxonomy field (if this field exists)
add_filter('acf/load_field/key=field_edu_anuncio_destino', function ($field) {
    if (current_user_can('manage_options')) {
        $field['add_term'] = 1;
    }
    return $field;
});
